/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.condition.Condition;
import com.consol.citrus.dsl.builder.WaitBuilder;

public abstract class WaitConditionBuilder<T extends Condition, S extends WaitConditionBuilder> {
    private final WaitBuilder builder;
    private final T condition;
    private S self;

    public WaitConditionBuilder(T condition, WaitBuilder builder) {
        this.condition = condition;
        this.builder = builder;
        this.self = this;
    }

    public S seconds(String seconds) {
        this.builder.seconds(seconds);
        return this.self;
    }

    public S seconds(Long seconds) {
        this.builder.seconds(seconds.toString());
        return this.self;
    }

    public S ms(String milliseconds) {
        this.builder.milliseconds(milliseconds);
        return this.self;
    }

    public S ms(Long milliseconds) {
        this.builder.milliseconds(String.valueOf(milliseconds));
        return this.self;
    }

    public S milliseconds(String milliseconds) {
        this.builder.milliseconds(milliseconds);
        return this.self;
    }

    public S milliseconds(Long milliseconds) {
        this.builder.milliseconds(String.valueOf(milliseconds));
        return this.self;
    }

    public S interval(String interval) {
        this.builder.interval(interval);
        return this.self;
    }

    public S interval(Long interval) {
        this.builder.interval(String.valueOf(interval));
        return this.self;
    }

    public T getCondition() {
        return this.condition;
    }

    public WaitBuilder getBuilder() {
        return this.builder;
    }
}

