/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.junit.jupiter;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.annotations.CitrusDslAnnotations;
import com.consol.citrus.dsl.design.DefaultTestDesigner;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.DefaultTestRunner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.jupiter.CitrusBaseExtension;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CitrusExtension
extends CitrusBaseExtension
implements TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (!CitrusExtension.isXmlTestMethod(extensionContext.getRequiredTestMethod()) && (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass()))) {
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)throwable));
        }
        throw throwable;
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        if (!CitrusExtension.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            extensionContext.getExecutionException().ifPresent(e -> testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e)));
            if (CitrusExtension.isDesignerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isDesignerClass(extensionContext.getRequiredTestClass())) {
                TestContext context = CitrusExtension.getTestContext((ExtensionContext)extensionContext);
                CitrusExtension.getCitrus((ExtensionContext)extensionContext).run((TestAction)testCase, context);
            } else if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass())) {
                CitrusExtension.getTestRunner(extensionContext).stop();
            }
            extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtension.getBaseKey((ExtensionContext)extensionContext) + TestRunner.class.getSimpleName()));
            extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtension.getBaseKey((ExtensionContext)extensionContext) + TestDesigner.class.getSimpleName()));
        }
        super.afterTestExecution(extensionContext);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        if (CitrusExtension.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            super.beforeTestExecution(extensionContext);
        }
        CitrusDslAnnotations.injectTestDesigner(extensionContext.getRequiredTestInstance(), CitrusExtension.getTestDesigner(extensionContext));
        CitrusDslAnnotations.injectTestRunner(extensionContext.getRequiredTestInstance(), CitrusExtension.getTestRunner(extensionContext));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (CitrusExtension.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            super.beforeEach(extensionContext);
        } else {
            CitrusExtension.getTestContext((ExtensionContext)extensionContext);
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass())) {
                TestRunner testRunner = CitrusExtension.getTestRunner(extensionContext);
                try {
                    testRunner.start();
                }
                catch (AssertionError | Exception e) {
                    CitrusExtension.getTestCase(extensionContext).setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                    throw new TestCaseFailedException((Throwable)e);
                }
            }
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (TestDesigner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtension.getTestDesigner(extensionContext);
        }
        if (TestRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtension.getTestRunner(extensionContext);
        }
        return super.resolveParameter(parameterContext, extensionContext);
    }

    protected static TestDesigner getTestDesigner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestDesigner)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtension.getBaseKey((ExtensionContext)extensionContext) + TestDesigner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            String testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            DefaultTestDesigner testDesigner = new DefaultTestDesigner(CitrusExtension.getCitrus((ExtensionContext)extensionContext).getApplicationContext(), CitrusExtension.getTestContext((ExtensionContext)extensionContext));
            testDesigner.testClass(extensionContext.getRequiredTestClass());
            testDesigner.name(testName);
            testDesigner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
            return testDesigner;
        }, TestDesigner.class);
    }

    protected static TestRunner getTestRunner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestRunner)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtension.getBaseKey((ExtensionContext)extensionContext) + TestRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            String testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            DefaultTestRunner testRunner = new DefaultTestRunner(CitrusExtension.getCitrus((ExtensionContext)extensionContext).getApplicationContext(), CitrusExtension.getTestContext((ExtensionContext)extensionContext));
            testRunner.testClass(extensionContext.getRequiredTestClass());
            testRunner.name(testName);
            testRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
            return testRunner;
        }, TestRunner.class);
    }

    protected static TestCase getTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtension.getBaseKey((ExtensionContext)extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusExtension.isDesignerMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtension.getTestDesigner(extensionContext).getTestCase();
            }
            if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtension.getTestRunner(extensionContext).getTestCase();
            }
            if (CitrusExtension.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusBaseExtension.getXmlTestCase((ExtensionContext)extensionContext);
            }
            if (CitrusExtension.isDesignerClass(extensionContext.getRequiredTestClass())) {
                return CitrusExtension.getTestDesigner(extensionContext).getTestCase();
            }
            if (Stream.of(extensionContext.getRequiredTestClass().getDeclaredFields()).anyMatch(field -> TestRunner.class.isAssignableFrom(field.getType()))) {
                return CitrusExtension.getTestRunner(extensionContext).getTestCase();
            }
            throw new CitrusRuntimeException("Neither test class nor test method is using any of test runner, designer or Xml test file.");
        }, TestCase.class);
    }

    private static boolean isDesignerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestDesigner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestDesigner.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDesignerClass(Class<?> type) {
        return Stream.of(type.getDeclaredFields()).anyMatch(field -> TestDesigner.class.isAssignableFrom(field.getType()));
    }

    private static boolean isRunnerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestRunner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestRunner.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRunnerClass(Class<?> type) {
        return Stream.of(type.getDeclaredFields()).anyMatch(field -> TestRunner.class.isAssignableFrom(field.getType()));
    }

    private static boolean isXmlTestMethod(Method method) {
        return method.isAnnotationPresent(CitrusXmlTest.class) || method.isAnnotationPresent(TestFactory.class);
    }
}

