/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class DmdbWriter
extends Writer {
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    private int typeFlag;
    private Object obj;
    private long objPos;
    private char[] buf;
    private int bufPos;

    public DmdbWriter(Object o2, long pos) throws SQLException {
        this.obj = o2;
        this.objPos = pos;
        this.buf = new char[32640];
        this.bufPos = 0;
        if (o2 instanceof DmdbBlob) {
            this.typeFlag = 1;
        } else if (o2 instanceof DmdbClob) {
            this.typeFlag = 2;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    @Override
    public void write(int a2) throws IOException {
        char[] tempByte = new char[]{(char)a2};
        this.write(tempByte, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] b2, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (off < 0) {
                DBError.throwIOException("off IndexOutOfBounds :" + off);
            }
            if (len < 0) {
                DBError.throwIOException("len IndexOutOfBounds :" + len);
            }
            if (off + len > b2.length) {
                DBError.throwIOException("off + len IndexOutOfBounds :" + off + len);
            }
            int writeLen = 0;
            while (writeLen < len) {
                int bufLeaveLen = this.bufLeaveLen();
                if (bufLeaveLen == 0) {
                    this.flush();
                    bufLeaveLen = this.bufLeaveLen();
                }
                int iLen = Math.min(bufLeaveLen, len - writeLen);
                System.arraycopy(b2, off, this.buf, this.bufPos, iLen);
                writeLen += iLen;
                this.bufPos += iLen;
                off += iLen;
            }
        }
    }

    @Override
    public void write(char[] b2) throws IOException {
        super.write(b2);
    }

    @Override
    public Writer append(char c2) throws IOException {
        return super.append(c2);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return super.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return super.append(csq, start, end);
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.bufPos <= 0) {
            return;
        }
        try {
            switch (this.typeFlag) {
                case 1: {
                    this.writeToBlob();
                    break;
                }
                case 2: {
                    this.writeToClob();
                    break;
                }
                default: {
                    DBError.throwIOException("Fatal error occured in DmdbWriter ");
                    break;
                }
            }
        }
        catch (SQLException e2) {
            DBError.throwIOException(e2.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private void writeToBlob() throws SQLException {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbBlob blob = (DmdbBlob)this.obj;
        byte[] bytes = ByteUtil.fromString(String.valueOf(this.buf, 0, this.bufPos), blob.connection.getServerEncoding());
        int writeLen = bytes == null ? 0 : blob.do_setBytes(this.objPos, bytes, 0, bytes.length);
        this.objPos += (long)writeLen;
        this.bufPos = 0;
    }

    private void writeToClob() throws SQLException {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbClob clob = (DmdbClob)this.obj;
        String str = String.valueOf(this.buf, 0, this.bufPos);
        int writeLen = clob.do_setString(this.objPos, str);
        this.objPos += (long)writeLen;
        this.bufPos = 0;
    }
}

