/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.util.ByteUtil;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Vector;

public class ComplexTypeData {
    public static final int ARRAY_TYPE_SHORT = 1;
    public static final int ARRAY_TYPE_INTEGER = 2;
    public static final int ARRAY_TYPE_LONG = 3;
    public static final int ARRAY_TYPE_FLOAT = 4;
    public static final int ARRAY_TYPE_DOUBLE = 5;
    public Object m_dumyData = null;
    public int m_offset = 0;
    public int m_bufLen;
    public byte[] m_dataBuf = null;
    public byte[] m_objBlobDescBuf = null;
    public boolean m_isFromBlob = false;
    public int m_packid = -1;
    public Vector<Object> m_objRefArr = new Vector(0);

    protected ComplexTypeData(Object val, byte[] dataBuf) {
        this.m_dumyData = val;
        this.m_offset = 0;
        this.m_bufLen = 0;
        this.m_dataBuf = dataBuf;
    }

    public static ComplexTypeData[] toStruct(Object[] objArr, ComplexTypeDesc desc) throws SQLException {
        int size = desc.getSize();
        ComplexTypeData[] retData = new ComplexTypeData[size];
        int i2 = 0;
        while (i2 < size) {
            if (objArr[i2] == null || objArr[i2] instanceof DmdbStruct || objArr[i2] instanceof DmdbArray) {
                retData[i2] = new ComplexTypeData(objArr[i2], null);
            } else if (objArr[i2] instanceof SQLData) {
                DmdbSQLOutput stream = new DmdbSQLOutput();
                ((SQLData)objArr[i2]).writeSQL(stream);
                DmdbStruct struct = new DmdbStruct(ComplexTypeData.toStruct(stream.getAttribs(), desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]);
                retData[i2] = new ComplexTypeData(struct, null);
            } else {
                switch (desc.m_fieldsObj[i2].getDType()) {
                    case 119: 
                    case 121: {
                        retData[i2] = new ComplexTypeData(new DmdbStruct(ComplexTypeData.toStruct((Object[])objArr[i2], desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        retData[i2] = new ComplexTypeData(new DmdbArray(ComplexTypeData.toArray((Object[])objArr[i2], desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]), null);
                        break;
                    }
                    default: {
                        retData[i2] = ComplexTypeData.toMemberObj(objArr[i2], desc.m_fieldsObj[i2]);
                    }
                }
            }
            ++i2;
        }
        return retData;
    }

    public static ComplexTypeData[] toArray(Object[] objArr, ComplexTypeDesc desc) throws SQLException {
        int size = objArr.length;
        ComplexTypeData[] retData = new ComplexTypeData[size];
        int i2 = 0;
        while (i2 < size) {
            if (objArr[i2] == null || objArr[i2] instanceof DmdbStruct || objArr[i2] instanceof DmdbArray) {
                retData[i2] = new ComplexTypeData(objArr[i2], null);
            } else {
                switch (desc.m_arrObj.getDType()) {
                    case 119: 
                    case 121: {
                        retData[i2] = new ComplexTypeData(new DmdbStruct(ComplexTypeData.toStruct((Object[])objArr[i2], desc.m_arrObj), desc.m_arrObj), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        if (!(objArr[i2] instanceof Object[]) && desc.m_arrObj.m_arrObj != null) {
                            objArr[i2] = ComplexTypeData.makeupObjToArr(objArr[i2], desc.m_arrObj);
                        }
                        retData[i2] = new ComplexTypeData(new DmdbArray(ComplexTypeData.toArray((Object[])objArr[i2], desc.m_arrObj), desc.m_arrObj), null);
                        break;
                    }
                    default: {
                        retData[i2] = ComplexTypeData.toMemberObj(objArr[i2], desc.m_arrObj);
                    }
                }
            }
            ++i2;
        }
        return retData;
    }

    private static Object[] makeupObjToArr(Object obj, ComplexTypeDesc objDesc) throws SQLException {
        int subType;
        int arrType = objDesc.getDType();
        boolean dynamic = true;
        int arrLen = 0;
        if (arrType == 122) {
            dynamic = false;
            arrLen = objDesc.getSize();
        }
        if ((subType = objDesc.m_arrObj.getDType()) == 17 || subType == 18 || subType == 3) {
            String strRet = "";
            if (obj instanceof Integer) {
                strRet = Integer.toBinaryString((Integer)obj);
            } else if (obj instanceof Long) {
                strRet = Long.toBinaryString((Long)obj);
            } else if (obj instanceof String) {
                strRet = (String)obj;
            } else {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            int prec = dynamic ? strRet.length() : arrLen;
            Object[] ret = new Object[prec];
            byte[] rs = ByteUtil.fromString(strRet, objDesc.getServerEncoding());
            int i2 = 0;
            while (i2 < prec) {
                ret[i2] = rs[i2];
                ++i2;
            }
            return ret;
        }
        DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        return null;
    }

    private static ComplexTypeData toMemberObj(Object mem, ComplexTypeDesc desc) throws SQLException {
        int scale = desc.getScale();
        int prec = desc.getPrec();
        int dtype = desc.getDType();
        if (mem == null) {
            return new ComplexTypeData(null, null);
        }
        Parameter param = new Parameter();
        param.type = dtype;
        param.prec = prec;
        param.scale = scale;
        byte[] bs = J2DB.fromObject(mem, param, desc.m_conn);
        return new ComplexTypeData(mem, bs);
    }

    private static byte[] typeDataToBytes(ComplexTypeData data, ComplexTypeDesc desc) throws SQLException {
        int dType = desc.getDType();
        if (data.m_dumyData == null) {
            byte[] innerData = ComplexTypeData.realocBuffer(null, 0, 2);
            ByteUtil.setByte(innerData, 0, (byte)0);
            ByteUtil.setByte(innerData, 1, (byte)0);
            return innerData;
        }
        switch (dType) {
            case 117: {
                byte[] innerData = ComplexTypeData.arrayToBytes((DmdbArray)data.m_dumyData, desc);
                byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                ByteUtil.setByte(result, 0, (byte)0);
                int offset = 1;
                ByteUtil.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 122: {
                byte[] innerData = ComplexTypeData.sarrayToBytes((DmdbArray)data.m_dumyData, desc);
                byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                ByteUtil.setByte(result, 0, (byte)0);
                int offset = 1;
                ByteUtil.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 119: {
                byte[] innerData = ComplexTypeData.objToBytes(data.m_dumyData, desc);
                byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                ByteUtil.setByte(result, 0, (byte)0);
                int offset = 1;
                ByteUtil.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 121: {
                byte[] innerData = ComplexTypeData.recordToBytes((DmdbStruct)data.m_dumyData, desc);
                byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                ByteUtil.setByte(result, 0, (byte)0);
                int offset = 1;
                ByteUtil.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 12: 
            case 19: {
                byte[] innerData = ComplexTypeData.convertLobToBytes(data.m_dumyData, desc.column.type, desc.getServerEncoding());
                byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                ByteUtil.setByte(result, 0, (byte)0);
                int offset = 1;
                ByteUtil.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 13: {
                byte[] innerData = ComplexTypeData.realocBuffer(null, 0, 2);
                ByteUtil.setByte(innerData, 0, (byte)0);
                if (data.m_dataBuf != null && data.m_dataBuf.length > 0) {
                    ByteUtil.setByte(innerData, 1, data.m_dataBuf[0]);
                } else {
                    ByteUtil.setByte(innerData, 1, (byte)0);
                }
                return innerData;
            }
        }
        byte[] innerData = data.m_dataBuf;
        byte[] result = ComplexTypeData.realocBuffer(null, 0, innerData.length + 1 + 1 + 2);
        ByteUtil.setByte(result, 0, (byte)0);
        int offset = 1;
        ByteUtil.setByte(result, offset, (byte)1);
        ByteUtil.setShort(result, ++offset, (short)innerData.length);
        System.arraycopy(innerData, 0, result, offset += 2, innerData.length);
        return result;
    }

    private static byte[] convertLobToBytes(Object value, int dtype, Charset serverEncoding) throws SQLException {
        if (dtype == 12) {
            DmdbBlob lob = (DmdbBlob)value;
            int len = (int)lob.do_length();
            byte[] tmp = lob.do_getBytes(1L, len);
            byte[] ret = new byte[len + 4];
            ByteUtil.setInt(ret, 0, len);
            System.arraycopy(tmp, 0, ret, 4, len);
            return ret;
        }
        if (dtype == 19) {
            DmdbClob lob = (DmdbClob)value;
            int len = (int)lob.do_length();
            String subString = lob.do_getSubString(1L, len);
            byte[] tmp = ByteUtil.fromString(subString, serverEncoding);
            byte[] ret = new byte[tmp.length + 4];
            ByteUtil.setInt(ret, 0, len);
            System.arraycopy(tmp, 0, ret, 4, len);
            return ret;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static byte[] sarrayToBytes(DmdbArray data, ComplexTypeDesc desc) throws SQLException {
        int realLen = data.m_arrData.length;
        byte[][] results = new byte[realLen][];
        if (desc.getObjId() == 4) {
            return ComplexTypeData.ctlnToBytes(data, desc);
        }
        int totalLen = 0;
        int i2 = 0;
        while (i2 < realLen) {
            results[i2] = ComplexTypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        byte[] rdata = ComplexTypeData.realocBuffer(null, 0, totalLen += 8);
        int off = 0;
        ByteUtil.setInt(rdata, off, totalLen);
        ByteUtil.setInt(rdata, off += 4, data.m_arrDesc.getSize());
        off += 4;
        int i3 = 0;
        while (i3 < realLen) {
            System.arraycopy(results[i3], 0, rdata, off, results[i3].length);
            off += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] ctlnToBytes(DmdbArray data, ComplexTypeDesc desc) throws SQLException {
        byte[][] results = new byte[data.m_arrData.length][];
        int totalLen = 5;
        totalLen += 8;
        int i2 = 0;
        while (i2 < data.m_arrData.length) {
            results[i2] = ComplexTypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        byte[] rdata = ComplexTypeData.realocBuffer(null, 0, totalLen);
        int offset = 0;
        ByteUtil.setByte(rdata, offset, (byte)0);
        ++offset;
        ByteUtil.setShort(rdata, offset += 4, (short)desc.getCltnType());
        ByteUtil.setShort(rdata, offset += 2, (short)desc.m_arrObj.getDType());
        ByteUtil.setInt(rdata, offset += 2, data.m_arrData.length);
        offset += 4;
        int i3 = 0;
        while (i3 < data.m_arrData.length) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        ByteUtil.setInt(rdata, 1, offset);
        return rdata;
    }

    public static byte[] arrayToBytes(DmdbArray data, ComplexTypeDesc desc) throws SQLException {
        byte[][] results = new byte[data.m_arrData.length][];
        if (desc.getObjId() == 4) {
            return ComplexTypeData.ctlnToBytes(data, desc);
        }
        int totalLen = 0;
        int i2 = 0;
        while (i2 < data.m_arrData.length) {
            results[i2] = ComplexTypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        totalLen += 20;
        int total = data.m_objCount + data.m_strCount;
        if (total > 0) {
            totalLen += 2 * total;
        }
        byte[] rdata = ComplexTypeData.realocBuffer(null, 0, totalLen);
        ByteUtil.setInt(rdata, 0, totalLen);
        int offset = 4;
        ByteUtil.setInt(rdata, offset, data.m_arrData.length);
        ByteUtil.setInt(rdata, offset += 4, 0);
        ByteUtil.setInt(rdata, offset += 4, data.m_objCount);
        ByteUtil.setInt(rdata, offset += 4, data.m_strCount);
        offset += 4;
        int i3 = 0;
        while (i3 < total) {
            ByteUtil.setInt(rdata, offset, data.m_objStrOffs[i3]);
            offset += 4;
            ++i3;
        }
        i3 = 0;
        while (i3 < data.m_arrData.length) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] objToBytes(Object data, ComplexTypeDesc desc) throws SQLException {
        if (data instanceof DmdbArray) {
            return ComplexTypeData.arrayToBytes((DmdbArray)data, desc);
        }
        return ComplexTypeData.structToBytes((DmdbStruct)data, desc);
    }

    public static byte[] structToBytes(DmdbStruct data, ComplexTypeDesc desc) throws SQLException {
        int size = desc.getSize();
        byte[][] results = new byte[size][];
        int totalLen = 0;
        int i2 = 0;
        while (i2 < size) {
            results[i2] = ComplexTypeData.typeDataToBytes(data.m_attribs[i2], desc.m_fieldsObj[i2]);
            totalLen += results[i2].length;
            ++i2;
        }
        byte[] rdata = ComplexTypeData.realocBuffer(null, 0, totalLen += 5);
        int offset = 0;
        ByteUtil.setByte(rdata, offset, (byte)0);
        ByteUtil.setInt(rdata, ++offset, totalLen);
        offset += 4;
        int i3 = 0;
        while (i3 < size) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] recordToBytes(DmdbStruct data, ComplexTypeDesc desc) throws SQLException {
        int size = desc.getSize();
        byte[][] results = new byte[size][];
        int totalLen = 0;
        int i2 = 0;
        while (i2 < size) {
            results[i2] = ComplexTypeData.typeDataToBytes(data.m_attribs[i2], desc.m_fieldsObj[i2]);
            totalLen += results[i2].length;
            ++i2;
        }
        byte[] rdata = ComplexTypeData.realocBuffer(null, 0, totalLen += 4);
        ByteUtil.setInt(rdata, 0, totalLen);
        int offset = 4;
        int i3 = 0;
        while (i3 < desc.getSize()) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    private static ComplexTypeData bytesToBlob(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        int offset = out.m_offset;
        int len = ByteUtil.getInt(val, offset);
        byte[] tmp = ByteUtil.getBytes(val, offset += 4, len);
        out.m_offset = offset += len;
        return new ComplexTypeData(DmdbBlob.newInstanceOfLocal(tmp, desc.m_conn), tmp);
    }

    private static ComplexTypeData bytesToClob(byte[] val, ComplexTypeData out, ComplexTypeDesc desc, Charset serverEncoding) throws SQLException {
        int offset = out.m_offset;
        int len = ByteUtil.getInt(val, offset);
        byte[] tmp = ByteUtil.getBytes(val, offset += 4, len);
        out.m_offset = offset += len;
        return new ComplexTypeData(DmdbClob.newInstance(ByteUtil.getString(tmp, 0, tmp.length, serverEncoding), desc.m_conn), tmp);
    }

    private static ComplexTypeData bytesToTypeData(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        int offset = out.m_offset;
        byte null_flag = ByteUtil.getByte(val, ++offset);
        out.m_offset = ++offset;
        if (desc.getDType() == 13) {
            boolean b2 = false;
            if (null_flag != 0) {
                b2 = true;
            }
            return new ComplexTypeData(b2, ByteUtil.getBytes(val, offset - 1, 1));
        }
        byte[] retDataBuf = null;
        switch (desc.getDType()) {
            case 119: {
                if ((null_flag & 1) != 0) {
                    Object retObj = ComplexTypeData.bytesToObj(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new ComplexTypeData(retObj, retDataBuf);
                }
                return new ComplexTypeData(null, null);
            }
            case 117: {
                if ((null_flag & 1) != 0) {
                    DmdbArray retObj = ComplexTypeData.bytesToArray(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new ComplexTypeData(retObj, retDataBuf);
                }
                return new ComplexTypeData(null, null);
            }
            case 121: {
                if ((null_flag & 1) != 0) {
                    DmdbStruct retObj = ComplexTypeData.bytesToRecord(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new ComplexTypeData(retObj, retDataBuf);
                }
                return new ComplexTypeData(null, null);
            }
            case 122: {
                if ((null_flag & 1) != 0) {
                    DmdbArray retObj = ComplexTypeData.bytesToSArray(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new ComplexTypeData(retObj, retDataBuf);
                }
                return new ComplexTypeData(null, null);
            }
            case 12: {
                if ((null_flag & 1) != 0) {
                    return ComplexTypeData.bytesToBlob(val, out, desc);
                }
                return new ComplexTypeData(null, null);
            }
            case 19: {
                if ((null_flag & 1) != 0) {
                    return ComplexTypeData.bytesToClob(val, out, desc, desc.getServerEncoding());
                }
                return new ComplexTypeData(null, null);
            }
        }
        if ((null_flag & 1) != 0) {
            return ComplexTypeData.convertBytes2BaseData(val, out, desc);
        }
        return new ComplexTypeData(null, null);
    }

    private static boolean checkObjExist(byte[] val, ComplexTypeData out) {
        int offset = out.m_offset;
        byte exist_flag = ByteUtil.getByte(val, offset);
        out.m_offset = ++offset;
        if (exist_flag == 1) {
            return true;
        }
        out.m_offset += 4;
        return false;
    }

    private static DmdbStruct findObjByPackId(byte[] val, ComplexTypeData out) throws SQLException {
        int offset = out.m_offset;
        int pack_id = ByteUtil.getInt(val, offset);
        out.m_offset = offset += 4;
        if (pack_id < 0 || pack_id > out.m_packid) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        return (DmdbStruct)out.m_objRefArr.get(pack_id);
    }

    private static void addObjToRefArr(ComplexTypeData out, Object objToAdd) {
        out.m_objRefArr.add(objToAdd);
        ++out.m_packid;
    }

    private static boolean checkObjClnt(ComplexTypeDesc desc) {
        return desc.m_objId == 4;
    }

    private static DmdbStruct bytesToObj_EXACT(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        DmdbStruct strOut = new DmdbStruct(null, desc);
        int offset = out.m_offset;
        int size = desc.getSize();
        out.m_offset = offset;
        strOut.m_attribs = new ComplexTypeData[size];
        int i2 = 0;
        while (i2 < size) {
            ComplexTypeDesc sub_desc = desc.m_fieldsObj[i2];
            strOut.m_attribs[i2] = ComplexTypeData.bytesToTypeData(val, out, sub_desc);
            ++i2;
        }
        strOut.m_dataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
        return strOut;
    }

    private static DmdbArray bytesToNestTab(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        int offset = out.m_offset;
        int count = ByteUtil.getInt(val, offset += 2);
        out.m_offset = offset += 4;
        DmdbArray arrOut = new DmdbArray(null, desc);
        arrOut.m_itemCount = count;
        arrOut.m_arrData = new ComplexTypeData[count];
        int i2 = 0;
        while (i2 < count) {
            arrOut.m_arrData[i2] = ComplexTypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    private static DmdbArray bytesToClnt(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        DmdbArray array = null;
        int offset = out.m_offset;
        short cltn_type = ByteUtil.getShort(val, offset);
        out.m_offset = offset += 2;
        switch (cltn_type) {
            case 3: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                array = ComplexTypeData.bytesToNestTab(val, out, desc);
            }
        }
        return array;
    }

    public static Object bytesToObj(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        ComplexTypeData retObj = null;
        if (out == null) {
            out = new ComplexTypeData(null, null);
        }
        if (ComplexTypeData.checkObjExist(val, out)) {
            retObj = ComplexTypeData.findObjByPackId(val, out);
        } else {
            ComplexTypeData.addObjToRefArr(out, retObj);
            retObj = ComplexTypeData.checkObjClnt(desc) ? ComplexTypeData.bytesToClnt(val, out, desc) : ComplexTypeData.bytesToObj_EXACT(val, out, desc);
        }
        return retObj;
    }

    public static DmdbArray bytesToArray(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        DmdbArray arrOut = new DmdbArray(null, desc);
        if (out == null) {
            out = new ComplexTypeData(null, null);
        }
        int offset = out.m_offset;
        arrOut.m_bufLen = ByteUtil.getInt(val, offset);
        arrOut.m_itemCount = ByteUtil.getInt(val, offset += 4);
        arrOut.m_itemSize = ByteUtil.getInt(val, offset += 4);
        arrOut.m_objCount = ByteUtil.getInt(val, offset += 4);
        arrOut.m_strCount = ByteUtil.getInt(val, offset += 4);
        offset += 4;
        int total = arrOut.m_objCount + arrOut.m_strCount;
        arrOut.m_objStrOffs = new int[total];
        int i2 = 0;
        while (i2 < total) {
            arrOut.m_objStrOffs[i2] = ByteUtil.getInt(val, offset);
            offset += 4;
            ++i2;
        }
        out.m_offset = offset;
        arrOut.m_arrData = new ComplexTypeData[arrOut.m_itemCount];
        i2 = 0;
        while (i2 < arrOut.m_itemCount) {
            arrOut.m_arrData[i2] = ComplexTypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    public static DmdbArray bytesToSArray(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        if (out == null) {
            out = new ComplexTypeData(null, null);
        }
        int offset = out.m_offset;
        DmdbArray arrOut = new DmdbArray(null, desc);
        arrOut.m_bufLen = ByteUtil.getInt(val, offset);
        arrOut.m_itemCount = ByteUtil.getInt(val, offset += 4);
        out.m_offset = offset += 4;
        arrOut.m_arrData = new ComplexTypeData[arrOut.m_itemCount];
        int i2 = 0;
        while (i2 < arrOut.m_itemCount) {
            arrOut.m_arrData[i2] = ComplexTypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    public static DmdbStruct bytesToRecord(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        if (out == null) {
            out = new ComplexTypeData(null, null);
        }
        int offset = out.m_offset;
        DmdbStruct strOut = new DmdbStruct(null, desc);
        strOut.m_bufLen = ByteUtil.getInt(val, offset);
        out.m_offset = offset += 4;
        strOut.m_attribs = new ComplexTypeData[desc.getSize()];
        int i2 = 0;
        while (i2 < desc.getSize()) {
            strOut.m_attribs[i2] = ComplexTypeData.bytesToTypeData(val, out, desc.m_fieldsObj[i2]);
            ++i2;
        }
        strOut.m_dataBuf = ByteUtil.getBytes(val, offset, out.m_offset - offset);
        return strOut;
    }

    private static void objBlob_GetChkBuf(byte[] buf, ComplexTypeData typeData) {
        int offset = 4;
        int len = ByteUtil.getInt(buf, offset);
        typeData.m_objBlobDescBuf = ByteUtil.getBytes(buf, offset += 4, len);
        typeData.m_isFromBlob = true;
        typeData.m_offset = offset += len;
    }

    public static Object objBlobToObj(Blob lob, ComplexTypeDesc desc) throws SQLException {
        ComplexTypeData typeData = new ComplexTypeData(null, null);
        int loblen = (int)lob.length();
        byte[] buf = lob.getBytes(1L, loblen);
        ComplexTypeData.objBlob_GetChkBuf(buf, typeData);
        return ComplexTypeData.bytesToObj(buf, typeData, desc);
    }

    public static byte[] objBlobToBytes(byte[] lobBuf, ComplexTypeDesc desc) throws SQLException {
        int descLen;
        byte[] descBuf;
        int len = lobBuf.length;
        int offset = 0;
        int magic = ByteUtil.getInt(lobBuf, offset);
        offset += 4;
        if (78111999 != magic) {
            DBError.ECJDBC_INVALID_OBJ_LOB.throwz(new Object[0]);
        }
        if (!Arrays.equals(descBuf = ByteUtil.getBytes(lobBuf, offset += 4, descLen = ByteUtil.getInt(lobBuf, offset)), desc.getClassDescChkInfo())) {
            DBError.ECJDBC_INVALID_OBJ_LOB.throwz(new Object[0]);
        }
        byte[] ret = new byte[len - (offset += descLen)];
        System.arraycopy(lobBuf, offset, ret, 0, ret.length);
        return ret;
    }

    private static byte[] realocBuffer(byte[] oldBuf, int offset, int needLen) {
        byte[] retBuf;
        if (oldBuf == null) {
            return new byte[needLen];
        }
        if (needLen + offset > oldBuf.length) {
            retBuf = new byte[oldBuf.length + needLen];
            System.arraycopy(oldBuf, 0, retBuf, 0, offset);
        } else {
            retBuf = oldBuf;
        }
        return retBuf;
    }

    private static ComplexTypeData convertBytes2BaseData(byte[] val, ComplexTypeData out, ComplexTypeDesc desc) throws SQLException {
        int offset = out.m_offset;
        boolean isNull = false;
        int valueLen = ByteUtil.getUB2(val, offset);
        offset += 2;
        if (valueLen == 65534) {
            valueLen = 0;
            isNull = true;
        }
        if (-1 == valueLen) {
            valueLen = ByteUtil.getInt(val, offset);
            offset += 4;
        }
        if (isNull) {
            out.m_offset = offset;
            return new ComplexTypeData(null, null);
        }
        byte[] temp = ByteUtil.getBytes(val, offset, valueLen);
        out.m_offset = offset += valueLen;
        Object tmpObj = DB2J.toObject(temp, desc.column, desc.m_conn, desc.m_conn.do_getTypeMap());
        return new ComplexTypeData(tmpObj, temp);
    }

    public Object toJavaArray(DmdbArray arr, int len, int dType) throws SQLException {
        return this.toJavaArray(arr, 1L, len, dType);
    }

    public Object toJavaArray(DmdbArray arr, long index, int len, int dType) throws SQLException {
        Object nr;
        if (arr.m_objArray != null) {
            return arr.m_objArray;
        }
        int realIdx = (int)(index - 1L);
        switch (dType) {
            case 0: 
            case 1: 
            case 2: {
                nr = new String[len];
                int i2 = 0;
                while (i2 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i2];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((String[])nr)[i2] = (String)tempData.m_dumyData;
                    }
                    ++i2;
                }
                break;
            }
            case 3: {
                nr = new Boolean[len];
                int i3 = 0;
                while (i3 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i3];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Boolean[])nr)[i3] = tempData.m_dumyData instanceof Boolean ? (Boolean)tempData.m_dumyData : Boolean.valueOf((Byte)tempData.m_dumyData == 1);
                    }
                    ++i3;
                }
                break;
            }
            case 5: {
                nr = new Byte[len];
                int i4 = 0;
                while (i4 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i4];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Byte[])nr)[i4] = (Byte)tempData.m_dumyData;
                    }
                    ++i4;
                }
                break;
            }
            case 17: 
            case 18: {
                nr = new byte[len][];
                int i5 = 0;
                while (i5 < len) {
                    byte[] temp;
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i5];
                    if (tempData != null && tempData.m_dumyData != null && (temp = (byte[])tempData.m_dumyData).length > 0) {
                        ((byte[][])nr)[i5] = temp;
                    }
                    ++i5;
                }
                break;
            }
            case 13: {
                nr = new Boolean[len];
                int i6 = 0;
                while (i6 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i6];
                    ((Boolean[])nr)[i6] = tempData != null && tempData.m_dumyData != null ? (Boolean)tempData.m_dumyData : null;
                    ++i6;
                }
                break;
            }
            case 6: {
                nr = new Short[len];
                int i7 = 0;
                while (i7 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i7];
                    ((Short[])nr)[i7] = tempData != null && tempData.m_dumyData != null ? (Short)tempData.m_dumyData : null;
                    ++i7;
                }
                break;
            }
            case 7: {
                nr = new Integer[len];
                int i8 = 0;
                while (i8 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i8];
                    ((Integer[])nr)[i8] = tempData != null && tempData.m_dumyData != null ? (Integer)tempData.m_dumyData : null;
                    ++i8;
                }
                break;
            }
            case 8: {
                nr = new Long[len];
                int i9 = 0;
                while (i9 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i9];
                    ((Long[])nr)[i9] = tempData != null && tempData.m_dumyData != null ? (Long)tempData.m_dumyData : null;
                    ++i9;
                }
                break;
            }
            case 9: {
                nr = new BigDecimal[len];
                int i10 = 0;
                while (i10 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i10];
                    ((BigDecimal[])nr)[i10] = tempData != null && tempData.m_dumyData != null ? new BigDecimal(String.valueOf(tempData.m_dumyData)) : null;
                    ++i10;
                }
                break;
            }
            case 10: {
                nr = new Float[len];
                int i11 = 0;
                while (i11 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i11];
                    ((Float[])nr)[i11] = tempData != null && tempData.m_dumyData != null ? (Float)tempData.m_dumyData : null;
                    ++i11;
                }
                break;
            }
            case 11: {
                nr = new Double[len];
                int i12 = 0;
                while (i12 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i12];
                    ((Double[])nr)[i12] = tempData != null && tempData.m_dumyData != null ? (Double)tempData.m_dumyData : null;
                    ++i12;
                }
                break;
            }
            case 14: {
                nr = new Date[len];
                int i13 = 0;
                while (i13 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i13];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Date[])nr)[i13] = (Date)tempData.m_dumyData;
                    }
                    ++i13;
                }
                break;
            }
            case 15: {
                nr = new Time[len];
                int i14 = 0;
                while (i14 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i14];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Time[])nr)[i14] = (Time)tempData.m_dumyData;
                    }
                    ++i14;
                }
                break;
            }
            case 16: 
            case 26: {
                nr = new Timestamp[len];
                int i15 = 0;
                while (i15 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i15];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Timestamp[])nr)[i15] = (Timestamp)tempData.m_dumyData;
                    }
                    ++i15;
                }
                break;
            }
            case 20: {
                nr = new DmdbIntervalYM[len];
                int i16 = 0;
                while (i16 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i16];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbIntervalYM[])nr)[i16] = (DmdbIntervalYM)tempData.m_dumyData;
                    }
                    ++i16;
                }
                break;
            }
            case 21: {
                nr = new DmdbIntervalDT[len];
                int i17 = 0;
                while (i17 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i17];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbIntervalDT[])nr)[i17] = (DmdbIntervalDT)tempData.m_dumyData;
                    }
                    ++i17;
                }
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                nr = new DmdbTimestamp[len];
                int i18 = 0;
                while (i18 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i18];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbTimestamp[])nr)[i18] = (DmdbTimestamp)tempData.m_dumyData;
                    }
                    ++i18;
                }
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                nr = new Object[len];
                int i19 = 0;
                while (i19 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i19];
                    nr[i19] = tempData != null ? tempData.m_dumyData : null;
                    ++i19;
                }
                break;
            }
            case 12: {
                nr = new DmdbBlob[len];
                int i20 = 0;
                while (i20 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i20];
                    ((DmdbBlob[])nr)[i20] = tempData != null && tempData.m_dumyData != null ? (DmdbBlob)tempData.m_dumyData : null;
                    ++i20;
                }
                break;
            }
            case 19: {
                nr = new DmdbClob[len];
                int i21 = 0;
                while (i21 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i21];
                    ((DmdbClob[])nr)[i21] = tempData != null && tempData.m_dumyData != null ? (DmdbClob)tempData.m_dumyData : null;
                    ++i21;
                }
                break;
            }
            case 28: {
                nr = new DmdbRowId[len];
                int i22 = 0;
                while (i22 < len) {
                    ComplexTypeData tempData = arr.m_arrData[realIdx + i22];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbRowId[])nr)[i22] = (DmdbRowId)tempData.m_dumyData;
                    }
                    ++i22;
                }
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                return null;
            }
        }
        return nr;
    }

    public Object toNumericArray(DmdbArray arr, long index, int len, int flag) throws SQLException {
        if (arr.m_objArray == null) {
            return null;
        }
        int realIdx = (int)(index - 1L);
        Object[] retObj = null;
        if (flag == 1 && arr.m_objArray instanceof short[]) {
            short[] ret = new short[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 2 && arr.m_objArray instanceof int[]) {
            int[] ret = new int[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 3 && arr.m_objArray instanceof long[]) {
            long[] ret = new long[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 4 && arr.m_objArray instanceof float[]) {
            float[] ret = new float[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 5 && arr.m_objArray instanceof double[]) {
            double[] ret = new double[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return retObj;
    }

    public Object[] toJavaArray(DmdbStruct struct) throws SQLException {
        ComplexTypeData[] attrsData = struct.getAttribsTypeData();
        if (struct.getAttribsTypeData() == null || struct.getAttribsTypeData().length <= 0) {
            return null;
        }
        ComplexTypeDesc[] fields = struct.m_strctDesc.m_fieldsObj;
        if (attrsData.length != fields.length) {
            DBError.ECJDBC_STRUCT_MEM_NOT_MATCH.throwz(new Object[0]);
        }
        Object[] out = new Object[fields.length];
        int i2 = 0;
        while (i2 < fields.length) {
            out[i2] = attrsData[i2].m_dumyData;
            ++i2;
        }
        return out;
    }

    public static byte[] toBytes(ComplexTypeData x2, ComplexTypeDesc typeDesc) throws SQLException {
        byte[] desc = typeDesc.getClassDescChkInfo();
        byte[] data = null;
        switch (typeDesc.getDType()) {
            case 117: {
                data = ComplexTypeData.arrayToBytes((DmdbArray)x2, typeDesc);
                break;
            }
            case 122: {
                data = ComplexTypeData.sarrayToBytes((DmdbArray)x2, typeDesc);
                break;
            }
            case 121: {
                data = ComplexTypeData.recordToBytes((DmdbStruct)x2, typeDesc);
                break;
            }
            case 119: {
                data = ComplexTypeData.objToBytes(x2, typeDesc);
                break;
            }
        }
        byte[] ret = new byte[8 + desc.length + data.length];
        ByteUtil.setInt(ret, 0, 78111999);
        ByteUtil.setInt(ret, 4, desc.length);
        System.arraycopy(desc, 0, ret, 8, desc.length);
        System.arraycopy(data, 0, ret, 8 + desc.length, data.length);
        return ret;
    }
}

