/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ToStringUtil {
    private static final String fGET_CLASS = "getClass";
    private static final String fCLONE = "clone";
    private static final String fHASH_CODE = "hashCode";
    private static final String fTO_STRING = "toString";
    private static final String fGET = "get";
    private static final Object[] fNO_ARGS = new Object[0];
    private static final Class[] fNO_PARAMS = new Class[0];
    private static final String fINDENT = "";
    private static final String fAVOID_CIRCULAR_REFERENCES = "[circular reference]";
    private static final Logger fLogger = Util.getLogger(ToStringUtil.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static Pattern PASSWORD_PATTERN = Pattern.compile("password", 2);
    private static String HIDDEN_PASSWORD_VALUE = "****";

    static String getText(Object aObject) {
        return ToStringUtil.getTextAvoidCyclicRefs(aObject, null, null);
    }

    static String getTextAvoidCyclicRefs(Object aObject, Class aSpecialClass, String aMethodName) {
        Method[] methods;
        StringBuilder result = new StringBuilder();
        ToStringUtil.addStartLine(aObject, result);
        for (Method method : methods = aObject.getClass().getDeclaredMethods()) {
            if (!ToStringUtil.isContributingMethod(method, aObject.getClass())) continue;
            ToStringUtil.addLineForGetXXXMethod(aObject, method, result, aSpecialClass, aMethodName);
        }
        ToStringUtil.addEndLine(result);
        return result.toString();
    }

    private ToStringUtil() {
    }

    private static void addStartLine(Object aObject, StringBuilder aResult) {
        aResult.append(aObject.getClass().getName());
        aResult.append(" {");
        aResult.append(NEW_LINE);
    }

    private static void addEndLine(StringBuilder aResult) {
        aResult.append("}");
        aResult.append(NEW_LINE);
    }

    private static boolean isContributingMethod(Method aMethod, Class aNativeClass) {
        boolean isPublic = Modifier.isPublic(aMethod.getModifiers());
        boolean hasNoArguments = aMethod.getParameterTypes().length == 0;
        boolean hasReturnValue = aMethod.getReturnType() != Void.TYPE;
        boolean returnsNativeObject = aMethod.getReturnType() == aNativeClass;
        boolean isMethodOfObjectClass = aMethod.getName().equals(fCLONE) || aMethod.getName().equals(fGET_CLASS) || aMethod.getName().equals(fHASH_CODE) || aMethod.getName().equals(fTO_STRING);
        return isPublic && hasNoArguments && hasReturnValue && !isMethodOfObjectClass && !returnsNativeObject;
    }

    private static void addLineForGetXXXMethod(Object aObject, Method aMethod, StringBuilder aResult, Class aCircularRefClass, String aCircularRefMethodName) {
        aResult.append(fINDENT);
        aResult.append(ToStringUtil.getMethodNameMinusGet(aMethod));
        aResult.append(": ");
        Object returnValue = ToStringUtil.getMethodReturnValue(aObject, aMethod);
        if (returnValue != null && returnValue.getClass().isArray()) {
            aResult.append(Util.getArrayAsString(returnValue));
        } else if (aCircularRefClass == null) {
            aResult.append(returnValue);
        } else if (aCircularRefClass == returnValue.getClass()) {
            Method method = ToStringUtil.getMethodFromName(aCircularRefClass, aCircularRefMethodName);
            if (ToStringUtil.isContributingMethod(method, aCircularRefClass)) {
                returnValue = ToStringUtil.getMethodReturnValue(returnValue, method);
                aResult.append(returnValue);
            } else {
                aResult.append(fAVOID_CIRCULAR_REFERENCES);
            }
        }
        aResult.append(NEW_LINE);
    }

    private static String getMethodNameMinusGet(Method aMethod) {
        String result = aMethod.getName();
        if (result.startsWith(fGET)) {
            result = result.substring(fGET.length());
        }
        return result;
    }

    private static Object getMethodReturnValue(Object aObject, Method aMethod) {
        Object result = null;
        try {
            result = aMethod.invoke(aObject, fNO_ARGS);
        }
        catch (IllegalAccessException ex) {
            ToStringUtil.vomit(aObject, aMethod);
        }
        catch (InvocationTargetException ex) {
            ToStringUtil.vomit(aObject, aMethod);
        }
        result = ToStringUtil.dontShowPasswords(result, aMethod);
        return result;
    }

    private static Method getMethodFromName(Class aSpecialClass, String aMethodName) {
        Method result = null;
        try {
            result = aSpecialClass.getMethod(aMethodName, fNO_PARAMS);
        }
        catch (NoSuchMethodException ex) {
            ToStringUtil.vomit(aSpecialClass, aMethodName);
        }
        return result;
    }

    private static void vomit(Object aObject, Method aMethod) {
        fLogger.severe("Cannot get return value using reflection. Class: " + aObject.getClass().getName() + " Method: " + aMethod.getName());
    }

    private static void vomit(Class aSpecialClass, String aMethodName) {
        fLogger.severe("Reflection fails to get no-arg method named: " + Util.quote(aMethodName) + " for class: " + aSpecialClass.getName());
    }

    private static Object dontShowPasswords(Object aReturnValue, Method aMethod) {
        Object result = aReturnValue;
        Matcher matcher = PASSWORD_PATTERN.matcher(aMethod.getName());
        if (matcher.find()) {
            result = HIDDEN_PASSWORD_VALUE;
        }
        return result;
    }

    public static void main(String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("blah");
        list.add("blah");
        list.add("blah");
        System.out.println(ToStringUtil.getText(list));
        StringTokenizer parser = new StringTokenizer("This is the end.");
        System.out.println(ToStringUtil.getText(parser));
        Ping ping = new Ping();
        Pong pong = new Pong();
        ping.setPong(pong);
        pong.setPing(ping);
        System.out.println(ping);
        System.out.println(pong);
    }

    private static final class Pong {
        private Ping fPing;

        private Pong() {
        }

        public void setPing(Ping aPing) {
            this.fPing = aPing;
        }

        public Ping getPing() {
            return this.fPing;
        }

        public String toString() {
            return ToStringUtil.getTextAvoidCyclicRefs(this, Ping.class, "getId");
        }
    }

    private static final class Ping {
        private Pong fPong;

        private Ping() {
        }

        public void setPong(Pong aPong) {
            this.fPong = aPong;
        }

        public Pong getPong() {
            return this.fPong;
        }

        public Integer getId() {
            return new Integer(123);
        }

        public String getUserPassword() {
            return "blah";
        }

        public String toString() {
            return ToStringUtil.getText(this);
        }
    }
}

