/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Jsonata;
import com.dashjoin.jsonata.Tokenizer;
import com.dashjoin.jsonata.Utils;
import com.dashjoin.jsonata.utils.Signature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class Parser {
    boolean dbg = false;
    String source;
    boolean recover;
    Symbol node;
    Tokenizer lexer;
    HashMap<String, Symbol> symbolTable = new HashMap();
    List<Exception> errors = new ArrayList<Exception>();
    int ancestorLabel = 0;
    int ancestorIndex = 0;
    List<Symbol> ancestry = new ArrayList<Symbol>();

    List<Tokenizer.Token> remainingTokens() {
        ArrayList<Tokenizer.Token> remaining = new ArrayList<Tokenizer.Token>();
        if (!this.node.id.equals("(end)")) {
            Tokenizer.Token t = new Tokenizer.Token();
            t.type = this.node.type;
            t.value = this.node.value;
            t.position = this.node.position;
            remaining.add(t);
        }
        Tokenizer.Token nxt = this.lexer.next(false);
        while (nxt != null) {
            remaining.add(nxt);
            nxt = this.lexer.next(false);
        }
        return remaining;
    }

    public static <T> T clone(T object) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(object);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));
            Object copy = in.readObject();
            in.close();
            return (T)copy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void register(Symbol t) {
        Symbol s = this.symbolTable.get(t.id);
        if (s != null) {
            if (this.dbg) {
                System.out.println("Symbol in table " + t.id + " " + s.getClass().getName() + " -> " + t.getClass().getName());
            }
            if (t.bp >= s.lbp) {
                if (this.dbg) {
                    System.out.println("Symbol in table " + t.id + " lbp=" + s.lbp + " -> " + t.bp);
                }
                s.lbp = t.bp;
            }
        } else {
            s = t.create();
            s.id = t.id;
            s.value = s.id;
            s.lbp = t.bp;
            this.symbolTable.put(t.id, s);
        }
    }

    public Symbol handleError(JException err) {
        if (this.recover) {
            err.remaining = this.remainingTokens();
            this.errors.add(err);
            Symbol node = new Symbol();
            return node;
        }
        throw err;
    }

    Symbol advance() {
        return this.advance(null);
    }

    Symbol advance(String id) {
        return this.advance(id, false);
    }

    Symbol advance(String id, boolean infix) {
        Symbol symbol;
        String type;
        if (id != null && !this.node.id.equals(id)) {
            String code = this.node.id.equals("(end)") ? "S0203" : "S0202";
            JException err = new JException(code, this.node.position, id, this.node.value);
            return this.handleError(err);
        }
        Tokenizer.Token next_token = this.lexer.next(infix);
        if (this.dbg) {
            System.out.println("nextToken " + (next_token != null ? next_token.type : null));
        }
        if (next_token == null) {
            this.node = this.symbolTable.get("(end)");
            this.node.position = this.source.length();
            return this.node;
        }
        Object value = next_token.value;
        switch (type = next_token.type) {
            case "name": 
            case "variable": {
                symbol = this.symbolTable.get("(name)");
                break;
            }
            case "operator": {
                symbol = this.symbolTable.get(String.valueOf(value));
                if (symbol != null) break;
                return this.handleError(new JException("S0204", next_token.position, value));
            }
            case "string": 
            case "number": 
            case "value": {
                symbol = this.symbolTable.get("(literal)");
                break;
            }
            case "regex": {
                type = "regex";
                symbol = this.symbolTable.get("(regex)");
                break;
            }
            default: {
                return this.handleError(new JException("S0205", next_token.position, value));
            }
        }
        this.node = symbol.create();
        this.node.value = value;
        this.node.type = type;
        this.node.position = next_token.position;
        if (this.dbg) {
            System.out.println("advance " + String.valueOf(this.node));
        }
        return this.node;
    }

    Symbol expression(int rbp) {
        Symbol t = this.node;
        this.advance(null, true);
        Symbol left = t.nud();
        while (rbp < this.node.lbp) {
            t = this.node;
            this.advance(null, false);
            if (this.dbg) {
                System.out.println("t=" + String.valueOf(t) + ", left=" + left.type);
            }
            left = t.led(left);
        }
        return left;
    }

    public Parser() {
        this.register(new Terminal("(end)"));
        this.register(new Terminal("(name)"));
        this.register(new Terminal("(literal)"));
        this.register(new Terminal("(regex)"));
        this.register(new Symbol(":"));
        this.register(new Symbol(";"));
        this.register(new Symbol(","));
        this.register(new Symbol(")"));
        this.register(new Symbol("]"));
        this.register(new Symbol("}"));
        this.register(new Symbol(".."));
        this.register(new Infix("."));
        this.register(new Infix("+"));
        this.register(new InfixAndPrefix("-"));
        this.register(new Infix("*"){

            @Override
            Symbol nud() {
                this.type = "wildcard";
                return this;
            }
        });
        this.register(new Infix("/"));
        this.register(new Infix("%"){

            @Override
            Symbol nud() {
                this.type = "parent";
                return this;
            }
        });
        this.register(new Infix("="));
        this.register(new Infix("<"));
        this.register(new Infix(">"));
        this.register(new Infix("!="));
        this.register(new Infix("<="));
        this.register(new Infix(">="));
        this.register(new Infix("&"));
        this.register(new Infix("and"){

            @Override
            Symbol nud() {
                return this;
            }
        });
        this.register(new Infix("or"){

            @Override
            Symbol nud() {
                return this;
            }
        });
        this.register(new Infix("in"){

            @Override
            Symbol nud() {
                return this;
            }
        });
        this.register(new Infix("~>"));
        this.register(new InfixR("(error)", 10){

            @Override
            Symbol led(Symbol left) {
                throw new UnsupportedOperationException("TODO", null);
            }
        });
        this.register(new Prefix("**"){

            @Override
            Symbol nud() {
                this.type = "descendant";
                return this;
            }
        });
        this.register(new Infix("(", Tokenizer.operators.get("(")){

            @Override
            Symbol led(Symbol left) {
                this.procedure = left;
                this.type = "function";
                this.arguments = new ArrayList();
                if (!Parser.this.node.id.equals(")")) {
                    while (true) {
                        if ("operator".equals(Parser.this.node.type) && Parser.this.node.id.equals("?")) {
                            this.type = "partial";
                            this.arguments.add(Parser.this.node);
                            Parser.this.advance("?");
                        } else {
                            this.arguments.add(Parser.this.expression(0));
                        }
                        if (!Parser.this.node.id.equals(",")) break;
                        Parser.this.advance(",");
                    }
                }
                Parser.this.advance(")", true);
                if (left.type.equals("name") && (left.value.equals("function") || left.value.equals("\u03bb"))) {
                    for (Symbol arg : this.arguments) {
                        if (arg.type.equals("variable")) continue;
                        return Parser.this.handleError(new JException("S0208", arg.position, arg.value));
                    }
                    this.type = "lambda";
                    if (Parser.this.node.id.equals("<")) {
                        int depth = 1;
                        Object sig = "<";
                        while (depth > 0 && !Parser.this.node.id.equals("{") && !Parser.this.node.id.equals("(end)")) {
                            Symbol tok = Parser.this.advance();
                            if (tok.id.equals(">")) {
                                --depth;
                            } else if (tok.id.equals("<")) {
                                ++depth;
                            }
                            sig = (String)sig + String.valueOf(tok.value);
                        }
                        Parser.this.advance(">");
                        this.signature = new Signature((String)sig, "lambda");
                    }
                    Parser.this.advance("{");
                    this.body = Parser.this.expression(0);
                    Parser.this.advance("}");
                }
                return this;
            }

            @Override
            Symbol nud() {
                if (Parser.this.dbg) {
                    System.out.println("Prefix (");
                }
                ArrayList<Symbol> expressions = new ArrayList<Symbol>();
                while (!Parser.this.node.id.equals(")")) {
                    expressions.add(Parser.this.expression(0));
                    if (!Parser.this.node.id.equals(";")) break;
                    Parser.this.advance(";");
                }
                Parser.this.advance(")", true);
                this.type = "block";
                this.expressions = expressions;
                return this;
            }
        });
        this.register(new Infix("[", Tokenizer.operators.get("[")){

            @Override
            Symbol nud() {
                ArrayList<Symbol> a = new ArrayList<Symbol>();
                if (!Parser.this.node.id.equals("]")) {
                    while (true) {
                        Symbol item = Parser.this.expression(0);
                        if (Parser.this.node.id.equals("..")) {
                            Symbol range = new Symbol();
                            range.type = "binary";
                            range.value = "..";
                            range.position = Parser.this.node.position;
                            range.lhs = item;
                            Parser.this.advance("..");
                            range.rhs = Parser.this.expression(0);
                            item = range;
                        }
                        a.add(item);
                        if (!Parser.this.node.id.equals(",")) break;
                        Parser.this.advance(",");
                    }
                }
                Parser.this.advance("]", true);
                this.expressions = a;
                this.type = "unary";
                return this;
            }

            @Override
            Symbol led(Symbol left) {
                if (Parser.this.node.id.equals("]")) {
                    Symbol step = left;
                    while (step != null && step.type.equals("binary") && step.value.equals("[")) {
                        step = ((Infix)step).lhs;
                    }
                    step.keepArray = true;
                    Parser.this.advance("]");
                    return left;
                }
                this.lhs = left;
                this.rhs = Parser.this.expression(Tokenizer.operators.get("]"));
                this.type = "binary";
                Parser.this.advance("]", true);
                return this;
            }
        });
        this.register(new Infix("^", Tokenizer.operators.get("^")){

            @Override
            Symbol led(Symbol left) {
                Parser.this.advance("(");
                ArrayList<Symbol> terms = new ArrayList<Symbol>();
                while (true) {
                    Symbol term = new Symbol();
                    term.descending = false;
                    if (Parser.this.node.id.equals("<")) {
                        Parser.this.advance("<");
                    } else if (Parser.this.node.id.equals(">")) {
                        term.descending = true;
                        Parser.this.advance(">");
                    }
                    term.expression = Parser.this.expression(0);
                    terms.add(term);
                    if (!Parser.this.node.id.equals(",")) break;
                    Parser.this.advance(",");
                }
                Parser.this.advance(")");
                this.lhs = left;
                this.rhsTerms = terms;
                this.type = "binary";
                return this;
            }
        });
        this.register(new Infix("{", Tokenizer.operators.get("{")){

            @Override
            Symbol nud() {
                return Parser.this.objectParser(null);
            }

            @Override
            Symbol led(Symbol left) {
                return Parser.this.objectParser(left);
            }
        });
        this.register(new InfixR(":=", Tokenizer.operators.get(":=")){

            @Override
            Symbol led(Symbol left) {
                if (!left.type.equals("variable")) {
                    return Parser.this.handleError(new JException("S0212", left.position, left.value));
                }
                this.lhs = left;
                this.rhs = Parser.this.expression(Tokenizer.operators.get(":=") - 1);
                this.type = "binary";
                return this;
            }
        });
        this.register(new Infix("@", Tokenizer.operators.get("@")){

            @Override
            Symbol led(Symbol left) {
                this.lhs = left;
                this.rhs = Parser.this.expression(Tokenizer.operators.get("@"));
                if (!this.rhs.type.equals("variable")) {
                    return Parser.this.handleError(new JException("S0214", this.rhs.position, "@"));
                }
                this.type = "binary";
                return this;
            }
        });
        this.register(new Infix("#", Tokenizer.operators.get("#")){

            @Override
            Symbol led(Symbol left) {
                this.lhs = left;
                this.rhs = Parser.this.expression(Tokenizer.operators.get("#"));
                if (!this.rhs.type.equals("variable")) {
                    return Parser.this.handleError(new JException("S0214", this.rhs.position, "#"));
                }
                this.type = "binary";
                return this;
            }
        });
        this.register(new Infix("?", Tokenizer.operators.get("?")){

            @Override
            Symbol led(Symbol left) {
                this.type = "condition";
                this.condition = left;
                this.then = Parser.this.expression(0);
                if (Parser.this.node.id.equals(":")) {
                    Parser.this.advance(":");
                    this._else = Parser.this.expression(0);
                }
                return this;
            }
        });
        this.register(new Prefix("|"){

            @Override
            Symbol nud() {
                this.type = "transform";
                this.pattern = Parser.this.expression(0);
                Parser.this.advance("|");
                this.update = Parser.this.expression(0);
                if (Parser.this.node.id.equals(",")) {
                    Parser.this.advance(",");
                    this.delete = Parser.this.expression(0);
                }
                Parser.this.advance("|");
                return this;
            }
        });
    }

    Symbol tailCallOptimize(Symbol expr) {
        Symbol result;
        if (expr.type.equals("function") && expr.predicate == null) {
            Symbol thunk = new Symbol();
            thunk.type = "lambda";
            thunk.thunk = true;
            thunk.arguments = List.of();
            thunk.position = expr.position;
            thunk.body = expr;
            result = thunk;
        } else if (expr.type.equals("condition")) {
            expr.then = this.tailCallOptimize(expr.then);
            if (expr._else != null) {
                expr._else = this.tailCallOptimize(expr._else);
            }
            result = expr;
        } else if (expr.type.equals("block")) {
            int length = expr.expressions.size();
            if (length > 0) {
                if (!(expr.expressions instanceof ArrayList)) {
                    expr.expressions = new ArrayList<Symbol>(expr.expressions);
                }
                expr.expressions.set(length - 1, this.tailCallOptimize(expr.expressions.get(length - 1)));
            }
            result = expr;
        } else {
            result = expr;
        }
        return result;
    }

    Symbol seekParent(Symbol node, Symbol slot) {
        switch (node.type) {
            case "name": 
            case "wildcard": {
                --slot.level;
                if (slot.level != 0) break;
                if (node.ancestor == null) {
                    node.ancestor = slot;
                } else {
                    this.ancestry.get((int)((Integer)slot.index).intValue()).slot.label = node.ancestor.label;
                    node.ancestor = slot;
                }
                node.tuple = true;
                break;
            }
            case "parent": {
                ++slot.level;
                break;
            }
            case "block": {
                if (node.expressions.size() <= 0) break;
                node.tuple = true;
                slot = this.seekParent(node.expressions.get(node.expressions.size() - 1), slot);
                break;
            }
            case "path": {
                node.tuple = true;
                int index = node.steps.size() - 1;
                slot = this.seekParent(node.steps.get(index--), slot);
                while (slot.level > 0 && index >= 0) {
                    slot = this.seekParent(node.steps.get(index--), slot);
                }
                break;
            }
            default: {
                throw new JException("S0217", node.position, node.type);
            }
        }
        return slot;
    }

    void pushAncestry(Symbol result, Symbol value) {
        if (value == null) {
            return;
        }
        if (value.seekingParent != null || value.type.equals("parent")) {
            ArrayList<Symbol> slots;
            ArrayList<Symbol> arrayList = slots = value.seekingParent != null ? value.seekingParent : new ArrayList<Symbol>();
            if (value.type.equals("parent")) {
                slots.add(value.slot);
            }
            if (result.seekingParent == null) {
                result.seekingParent = slots;
            } else {
                result.seekingParent.addAll(slots);
            }
        }
    }

    void resolveAncestry(Symbol path) {
        ArrayList<Symbol> slots;
        int index = path.steps.size() - 1;
        Symbol laststep = path.steps.get(index);
        ArrayList<Symbol> arrayList = slots = laststep.seekingParent != null ? laststep.seekingParent : new ArrayList<Symbol>();
        if (laststep.type.equals("parent")) {
            slots.add(laststep.slot);
        }
        block0: for (int is = 0; is < slots.size(); ++is) {
            Symbol slot = (Symbol)slots.get(is);
            index = path.steps.size() - 2;
            while (slot.level > 0) {
                if (index < 0) {
                    if (path.seekingParent == null) {
                        path.seekingParent = new ArrayList<Symbol>(Arrays.asList(slot));
                        continue block0;
                    }
                    path.seekingParent.add(slot);
                    continue block0;
                }
                Symbol step = path.steps.get(index--);
                while (index >= 0 && step.focus != null && path.steps.get((int)index).focus != null) {
                    step = path.steps.get(index--);
                }
                slot = this.seekParent(step, slot);
            }
        }
    }

    Symbol processAST(Symbol expr) {
        Symbol result = expr;
        if (expr == null) {
            return null;
        }
        if (this.dbg) {
            System.out.println(" > processAST type=" + expr.type + " value='" + String.valueOf(expr.value) + "'");
        }
        block21 : switch (expr.type != null ? expr.type : "(null)") {
            case "binary": {
                switch (String.valueOf(expr.value)) {
                    case ".": {
                        Symbol lstep = this.processAST(((Infix)expr).lhs);
                        if (lstep.type.equals("path")) {
                            result = lstep;
                        } else {
                            result = new Infix(null);
                            result.type = "path";
                            result.steps = new ArrayList<Symbol>(Arrays.asList(lstep));
                        }
                        if (lstep.type.equals("parent")) {
                            result.seekingParent = new ArrayList<Symbol>(Arrays.asList(lstep.slot));
                        }
                        Symbol rest = this.processAST(((Infix)expr).rhs);
                        if (rest.type.equals("function") && rest.procedure.type.equals("path") && rest.procedure.steps.size() == 1 && rest.procedure.steps.get((int)0).type.equals("name") && result.steps.get((int)(result.steps.size() - 1)).type.equals("function")) {
                            result.steps.get((int)(result.steps.size() - 1)).nextFunction = (Symbol)rest.procedure.steps.get((int)0).value;
                        }
                        if (rest.type.equals("path")) {
                            result.steps.addAll(rest.steps);
                        } else {
                            if (rest.predicate != null) {
                                rest.stages = rest.predicate;
                                rest.predicate = null;
                            }
                            result.steps.add(rest);
                        }
                        for (Symbol step2 : result.steps) {
                            if (step2.type.equals("number") || step2.type.equals("value")) {
                                throw new JException("S0213", step2.position, step2.value);
                            }
                            if (!step2.type.equals("string")) continue;
                            step2.type = "name";
                        }
                        if (result.steps.stream().filter(step -> step.keepArray).count() > 0L) {
                            result.keepSingletonArray = true;
                        }
                        Symbol firststep = result.steps.get(0);
                        if (firststep.type.equals("unary") && String.valueOf(firststep.value).equals("[")) {
                            firststep.consarray = true;
                        }
                        Symbol laststep = result.steps.get(result.steps.size() - 1);
                        if (laststep.type.equals("unary") && String.valueOf(laststep.value).equals("[")) {
                            laststep.consarray = true;
                        }
                        this.resolveAncestry(result);
                        break block21;
                    }
                    case "[": {
                        if (this.dbg) {
                            System.out.println("binary [");
                        }
                        Symbol step3 = result = this.processAST(((Infix)expr).lhs);
                        String type = "predicate";
                        if (result.type.equals("path")) {
                            step3 = result.steps.get(result.steps.size() - 1);
                            type = "stages";
                        }
                        if (step3.group != null) {
                            throw new JException("S0209", expr.position);
                        }
                        if (type.equals("stages")) {
                            if (step3.stages == null) {
                                step3.stages = new ArrayList<Symbol>();
                            }
                        } else if (step3.predicate == null) {
                            step3.predicate = new ArrayList<Symbol>();
                        }
                        Symbol predicate = this.processAST(((Infix)expr).rhs);
                        if (predicate.seekingParent != null) {
                            Symbol _step = step3;
                            predicate.seekingParent.forEach(slot -> {
                                if (slot.level == 1) {
                                    this.seekParent(_step, (Symbol)slot);
                                } else {
                                    --slot.level;
                                }
                            });
                            this.pushAncestry(step3, predicate);
                        }
                        Symbol s = new Symbol();
                        s.type = "filter";
                        s.expr = predicate;
                        s.position = expr.position;
                        if (expr.keepArray) {
                            step3.keepArray = true;
                        }
                        if (type.equals("stages")) {
                            step3.stages.add(s);
                            break block21;
                        }
                        step3.predicate.add(s);
                        break block21;
                    }
                    case "{": {
                        result = this.processAST(expr.lhs);
                        if (result.group != null) {
                            throw new JException("S0210", expr.position);
                        }
                        result.group = new Symbol();
                        result.group.lhsObject = expr.rhsObject.stream().map(pair -> new Symbol[]{this.processAST(pair[0]), this.processAST(pair[1])}).collect(Collectors.toList());
                        result.group.position = expr.position;
                        break block21;
                    }
                    case "^": {
                        result = this.processAST(expr.lhs);
                        if (!result.type.equals("path")) {
                            Symbol _res = new Symbol();
                            _res.type = "path";
                            _res.steps = new ArrayList<Symbol>();
                            _res.steps.add(result);
                            result = _res;
                        }
                        Symbol sortStep = new Symbol();
                        sortStep.type = "sort";
                        sortStep.position = expr.position;
                        sortStep.terms = expr.rhsTerms.stream().map(terms -> {
                            Symbol expression = this.processAST(terms.expression);
                            this.pushAncestry(sortStep, expression);
                            Symbol res = new Symbol();
                            res.descending = terms.descending;
                            res.expression = expression;
                            return res;
                        }).collect(Collectors.toList());
                        result.steps.add(sortStep);
                        this.resolveAncestry(result);
                        break block21;
                    }
                    case ":=": {
                        result = new Symbol();
                        result.type = "bind";
                        result.value = expr.value;
                        result.position = expr.position;
                        result.lhs = this.processAST(expr.lhs);
                        result.rhs = this.processAST(expr.rhs);
                        this.pushAncestry(result, result.rhs);
                        break block21;
                    }
                    case "@": {
                        Symbol step4 = result = this.processAST(expr.lhs);
                        if (result.type.equals("path")) {
                            step4 = result.steps.get(result.steps.size() - 1);
                        }
                        if (step4.stages != null || step4.predicate != null) {
                            throw new JException("S0215", expr.position);
                        }
                        if (step4.type.equals("sort")) {
                            throw new JException("S0216", expr.position);
                        }
                        if (expr.keepArray) {
                            step4.keepArray = true;
                        }
                        step4.focus = expr.rhs.value;
                        step4.tuple = true;
                        break block21;
                    }
                    case "#": {
                        Symbol _res;
                        Symbol step5 = result = this.processAST(expr.lhs);
                        if (result.type.equals("path")) {
                            step5 = result.steps.get(result.steps.size() - 1);
                        } else {
                            _res = new Symbol();
                            _res.type = "path";
                            _res.steps = new ArrayList<Symbol>();
                            _res.steps.add(result);
                            result = _res;
                            if (step5.predicate != null) {
                                step5.stages = step5.predicate;
                                step5.predicate = null;
                            }
                        }
                        if (step5.stages == null) {
                            step5.index = expr.rhs.value;
                        } else {
                            _res = new Symbol();
                            _res.type = "index";
                            _res.value = expr.rhs.value;
                            _res.position = expr.position;
                            step5.stages.add(_res);
                        }
                        step5.tuple = true;
                        break block21;
                    }
                    case "~>": {
                        result = new Symbol();
                        result.type = "apply";
                        result.value = expr.value;
                        result.position = expr.position;
                        result.lhs = this.processAST(expr.lhs);
                        result.rhs = this.processAST(expr.rhs);
                        break block21;
                    }
                }
                Infix _result = new Infix(null);
                _result.type = expr.type;
                _result.value = expr.value;
                _result.position = expr.position;
                _result.lhs = this.processAST(expr.lhs);
                _result.rhs = this.processAST(expr.rhs);
                this.pushAncestry(_result, _result.lhs);
                this.pushAncestry(_result, _result.rhs);
                result = _result;
                break;
            }
            case "unary": {
                result = new Symbol();
                result.type = expr.type;
                result.value = expr.value;
                result.position = expr.position;
                String exprValue = String.valueOf(expr.value);
                if (exprValue.equals("[")) {
                    if (this.dbg) {
                        System.out.println("unary [ " + String.valueOf(result));
                    }
                    Symbol _result = result;
                    result.expressions = expr.expressions.stream().map(item -> {
                        Symbol value = this.processAST((Symbol)item);
                        this.pushAncestry(_result, value);
                        return value;
                    }).collect(Collectors.toList());
                    break;
                }
                if (exprValue.equals("{")) {
                    Symbol _result = result;
                    result.lhsObject = expr.lhsObject.stream().map(pair -> {
                        Symbol key = this.processAST(pair[0]);
                        this.pushAncestry(_result, key);
                        Symbol value = this.processAST(pair[1]);
                        this.pushAncestry(_result, value);
                        return new Symbol[]{key, value};
                    }).collect(Collectors.toList());
                    break;
                }
                result.expression = this.processAST(expr.expression);
                if (exprValue.equals("-") && result.expression.type.equals("number")) {
                    result = result.expression;
                    result.value = Utils.convertNumber(-((Number)result.value).doubleValue());
                    if (!this.dbg) break;
                    System.out.println("unary - value=" + String.valueOf(result.value));
                    break;
                }
                this.pushAncestry(result, result.expression);
                break;
            }
            case "function": 
            case "partial": {
                result = new Symbol();
                result.type = expr.type;
                result.name = expr.name;
                result.value = expr.value;
                result.position = expr.position;
                Symbol _result = result;
                result.arguments = expr.arguments.stream().map(arg -> {
                    Symbol argAST = this.processAST((Symbol)arg);
                    this.pushAncestry(_result, argAST);
                    return argAST;
                }).collect(Collectors.toList());
                result.procedure = this.processAST(expr.procedure);
                break;
            }
            case "lambda": {
                result = new Symbol();
                result.type = expr.type;
                result.arguments = expr.arguments;
                result.signature = expr.signature;
                result.position = expr.position;
                Symbol body = this.processAST(expr.body);
                result.body = this.tailCallOptimize(body);
                break;
            }
            case "condition": {
                result = new Symbol();
                result.type = expr.type;
                result.position = expr.position;
                result.condition = this.processAST(expr.condition);
                this.pushAncestry(result, result.condition);
                result.then = this.processAST(expr.then);
                this.pushAncestry(result, result.then);
                if (expr._else == null) break;
                result._else = this.processAST(expr._else);
                this.pushAncestry(result, result._else);
                break;
            }
            case "transform": {
                result = new Symbol();
                result.type = expr.type;
                result.position = expr.position;
                result.pattern = this.processAST(expr.pattern);
                result.update = this.processAST(expr.update);
                if (expr.delete == null) break;
                result.delete = this.processAST(expr.delete);
                break;
            }
            case "block": {
                result = new Symbol();
                result.type = expr.type;
                result.position = expr.position;
                Symbol __result = result;
                result.expressions = expr.expressions.stream().map(item -> {
                    Symbol part = this.processAST((Symbol)item);
                    this.pushAncestry(__result, part);
                    if (part.consarray || part.type.equals("path") && part.steps.get((int)0).consarray) {
                        __result.consarray = true;
                    }
                    return part;
                }).collect(Collectors.toList());
                break;
            }
            case "name": {
                result = new Symbol();
                result.type = "path";
                result.steps = new ArrayList<Symbol>();
                result.steps.add(expr);
                if (!expr.keepArray) break;
                result.keepSingletonArray = true;
                break;
            }
            case "parent": {
                result = new Symbol();
                result.type = "parent";
                result.slot = new Symbol();
                result.slot.label = "!" + this.ancestorLabel++;
                result.slot.level = 1;
                result.slot.index = this.ancestorIndex++;
                this.ancestry.add(result);
                break;
            }
            case "string": 
            case "number": 
            case "value": 
            case "wildcard": 
            case "descendant": 
            case "variable": 
            case "regex": {
                result = expr;
                break;
            }
            case "operator": {
                if (expr.value.equals("and") || expr.value.equals("or") || expr.value.equals("in")) {
                    expr.type = "name";
                    result = this.processAST(expr);
                    break;
                }
                if (String.valueOf(expr.value).equals("?")) {
                    result = expr;
                    break;
                }
                throw new JException("S0201", expr.position, expr.value);
            }
            case "error": {
                result = expr;
                if (expr.lhs == null) break;
                result = this.processAST(expr.lhs);
                break;
            }
            default: {
                String code = "S0206";
                if (expr.id.equals("(end)")) {
                    code = "S0207";
                }
                JException err = new JException(code, expr.position, expr.value);
                if (this.recover) {
                    this.errors.add(err);
                    Symbol ret = new Symbol();
                    ret.type = "error";
                    ret.error = err;
                    return ret;
                }
                throw err;
            }
        }
        if (expr.keepArray) {
            result.keepArray = true;
        }
        return result;
    }

    Symbol objectParser(Symbol left) {
        Symbol res = left != null ? new Infix("{") : new Prefix("{");
        ArrayList<Symbol[]> a = new ArrayList<Symbol[]>();
        if (!this.node.id.equals("}")) {
            while (true) {
                Symbol n = this.expression(0);
                this.advance(":");
                Symbol v = this.expression(0);
                Symbol[] pair = new Symbol[]{n, v};
                a.add(pair);
                if (!this.node.id.equals(",")) break;
                this.advance(",");
            }
        }
        this.advance("}", true);
        if (left == null) {
            ((Prefix)res).lhsObject = a;
            ((Prefix)res).type = "unary";
        } else {
            res.lhs = left;
            res.rhsObject = a;
            res.type = "binary";
        }
        return res;
    }

    public Symbol parse(String jsonata) {
        this.source = jsonata;
        this.lexer = new Tokenizer(this.source);
        this.advance();
        Symbol expr = this.expression(0);
        if (!this.node.id.equals("(end)")) {
            JException err = new JException("S0201", this.node.position, this.node.value);
            this.handleError(err);
        }
        expr = this.processAST(expr);
        if (expr.type.equals("parent") || expr.seekingParent != null) {
            throw new JException("S0217", expr.position, expr.type);
        }
        if (this.errors.size() > 0) {
            expr.errors = this.errors;
        }
        return expr;
    }

    class Symbol
    implements Cloneable {
        String id;
        String type;
        Object value;
        int bp;
        int lbp;
        int position;
        boolean keepArray;
        boolean descending;
        Symbol expression;
        public List<Symbol> seekingParent;
        public List<Exception> errors;
        List<Symbol> steps;
        Symbol slot;
        Symbol nextFunction;
        public boolean keepSingletonArray;
        public boolean consarray;
        public int level;
        public Object focus;
        public Object token;
        public boolean thunk;
        Symbol procedure;
        List<Symbol> arguments;
        Symbol body;
        List<Symbol> predicate;
        public List<Symbol> stages;
        public Object input;
        public Jsonata.Frame environment;
        public Object tuple;
        public Object expr;
        public Symbol group;
        public Object name;
        Symbol lhs;
        Symbol rhs;
        public List<Symbol[]> lhsObject;
        public List<Symbol[]> rhsObject;
        List<Symbol> rhsTerms;
        List<Symbol> terms;
        Symbol condition;
        Symbol then;
        Symbol _else;
        List<Symbol> expressions;
        public JException error;
        public Object signature;
        Symbol pattern;
        Symbol update;
        Symbol delete;
        public String label;
        public Object index;
        public boolean _jsonata_lambda;
        public Symbol ancestor;

        Symbol nud() {
            JException _err = new JException("S0211", this.position, this.value);
            if (Parser.this.recover) {
                return new Symbol("(error)"){};
            }
            throw _err;
        }

        Symbol led(Symbol left) {
            throw new Error("led not implemented");
        }

        Symbol() {
        }

        Symbol(String id) {
            this(id, 0);
        }

        Symbol(String id, int bp) {
            this.id = id;
            this.value = id;
            this.bp = bp;
        }

        public Symbol create() {
            try {
                Symbol cl = (Symbol)this.clone();
                return cl;
            }
            catch (CloneNotSupportedException e) {
                if (Parser.this.dbg) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.id + " value=" + String.valueOf(this.value);
        }
    }

    class Terminal
    extends Symbol {
        Terminal(String id) {
            super(id, 0);
        }

        @Override
        Symbol nud() {
            return this;
        }
    }

    class Infix
    extends Symbol {
        Infix(String id) {
            this(id, 0);
        }

        Infix(String id, int bp) {
            super(id, bp != 0 ? bp : (id != null ? Tokenizer.operators.get(id) : 0));
        }

        @Override
        Symbol led(Symbol left) {
            this.lhs = left;
            this.rhs = Parser.this.expression(this.bp);
            this.type = "binary";
            return this;
        }
    }

    class InfixAndPrefix
    extends Infix {
        Prefix prefix;

        InfixAndPrefix(String id) {
            this(id, 0);
        }

        InfixAndPrefix(String id, int bp) {
            super(id, bp);
            this.prefix = new Prefix(id);
        }

        @Override
        Symbol nud() {
            return this.prefix.nud();
        }

        public Object clone() throws CloneNotSupportedException {
            Object c = super.clone();
            ((InfixAndPrefix)c).prefix = new Prefix(((InfixAndPrefix)c).id);
            return c;
        }
    }

    class Prefix
    extends Symbol {
        Prefix(String id) {
            super(id);
        }

        @Override
        Symbol nud() {
            this.expression = Parser.this.expression(70);
            this.type = "unary";
            return this;
        }
    }

    class InfixR
    extends Symbol {
        InfixR(String id, int bp) {
            super(id, bp);
        }
    }
}

