/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.markdown;

import com.deepoove.poi.data.style.BorderStyle;
import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.RowStyle;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.plugin.highlight.HighlightStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;

public class MarkdownStyle {
    private Style inlineCodeStyle;
    private HighlightStyle highlightStyle;
    private ParagraphStyle quoteStyle;
    private BorderStyle tableBorderStyle;
    private RowStyle tableHeaderStyle;
    private boolean showHeaderNumber;
    private String imagesDir = "";

    public static MarkdownStyle newStyle() {
        MarkdownStyle style = new MarkdownStyle();
        style.setInlineCodeStyle(Style.builder().buildColor("f44336").buildFontFamily("Monaco").build());
        style.setHighlightStyle(HighlightStyle.builder().withTheme("zenburn").withFontFamily("Consolas").withFontSize(9.0).build());
        style.setQuoteStyle(ParagraphStyle.builder().withIndentLeftChars(1.0).withLeftBorder(BorderStyle.builder().withColor("70ad47").withSize(48).withSpace(8).withType(XWPFTable.XWPFBorderType.SINGLE).build()).build());
        style.setTableBorderStyle(BorderStyle.builder().withColor("BFBFBF").withSize(1).withType(XWPFTable.XWPFBorderType.SINGLE).build());
        RowStyle headerStyle = new RowStyle();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setBackgroundColor("5b9bd5");
        Style textStyle = new Style();
        textStyle.setColor("ffffff");
        cellStyle.setDefaultParagraphStyle(ParagraphStyle.builder().withDefaultTextStyle(textStyle).build());
        headerStyle.setDefaultCellStyle(cellStyle);
        style.setTableHeaderStyle(headerStyle);
        return style;
    }

    public Style getInlineCodeStyle() {
        return this.inlineCodeStyle;
    }

    public void setInlineCodeStyle(Style inlineCodeStyle) {
        this.inlineCodeStyle = inlineCodeStyle;
    }

    public HighlightStyle getHighlightStyle() {
        return this.highlightStyle;
    }

    public void setHighlightStyle(HighlightStyle highlightStyle) {
        this.highlightStyle = highlightStyle;
    }

    public ParagraphStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public void setQuoteStyle(ParagraphStyle quoteStyle) {
        this.quoteStyle = quoteStyle;
    }

    public BorderStyle getTableBorderStyle() {
        return this.tableBorderStyle;
    }

    public void setTableBorderStyle(BorderStyle tableBorderStyle) {
        this.tableBorderStyle = tableBorderStyle;
    }

    public RowStyle getTableHeaderStyle() {
        return this.tableHeaderStyle;
    }

    public void setTableHeaderStyle(RowStyle tableHeaderStyle) {
        this.tableHeaderStyle = tableHeaderStyle;
    }

    public boolean isShowHeaderNumber() {
        return this.showHeaderNumber;
    }

    public void setShowHeaderNumber(boolean showHeaderNumber) {
        this.showHeaderNumber = showHeaderNumber;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }
}

