/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.exception.RenderException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGConvertor {
    private static Logger logger = LoggerFactory.getLogger(SVGConvertor.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toPng(byte[] svgs, float width, float maxHeight, int svgScale) throws TranscoderException, IOException {
        PNGTranscoder t = new PNGTranscoder();
        t.setErrorHandler(new ErrorHandler(){

            public void warning(TranscoderException ex) throws TranscoderException {
                logger.warn("WARNING: " + ex.getMessage());
            }

            public void fatalError(TranscoderException ex) throws TranscoderException {
                throw ex;
            }

            public void error(TranscoderException ex) throws TranscoderException {
                throw ex;
            }
        });
        if (0.0f != width) {
            t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width * (float)svgScale));
        }
        if (0.0f != maxHeight) {
            t.addTranscodingHint(PNGTranscoder.KEY_MAX_HEIGHT, (Object)Float.valueOf(maxHeight * (float)svgScale));
        }
        try (ByteArrayInputStream instream = new ByteArrayInputStream(svgs);){
            byte[] byArray;
            try (ByteArrayOutputStream ostream = new ByteArrayOutputStream();){
                TranscoderInput input = new TranscoderInput((InputStream)instream);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                t.transcode(input, output);
                ostream.flush();
                byArray = ostream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RenderException("Unable transcode from svg to png, possibly some svg attribute is not supported.", e);
        }
    }
}

