/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.CellBodyContainer;
import com.deepoove.poi.xwpf.CommentBodyContainer;
import com.deepoove.poi.xwpf.DocumentBodyContainer;
import com.deepoove.poi.xwpf.HeaderFooterBodyContainer;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.deepoove.poi.xwpf.SDTBodyContainer;
import com.deepoove.poi.xwpf.TextBoxBodyContainer;
import com.deepoove.poi.xwpf.XWPFStructuredDocumentTagContent;
import com.deepoove.poi.xwpf.XWPFTextboxContent;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class BodyContainerFactory {
    public static BodyContainer getBodyContainer(IBody body) {
        if (body instanceof XWPFTableCell) {
            return new CellBodyContainer((XWPFTableCell)body);
        }
        if (body instanceof XWPFHeaderFooter) {
            return new HeaderFooterBodyContainer((XWPFHeaderFooter)body);
        }
        if (body instanceof XWPFTextboxContent) {
            return new TextBoxBodyContainer((XWPFTextboxContent)body);
        }
        if (body instanceof XWPFComment) {
            return new CommentBodyContainer((XWPFComment)body);
        }
        if (body instanceof XWPFStructuredDocumentTagContent) {
            return new SDTBodyContainer((XWPFStructuredDocumentTagContent)body);
        }
        return new DocumentBodyContainer((NiceXWPFDocument)body);
    }

    public static BodyContainer getBodyContainer(XWPFRun run) {
        assert (run.getParent() instanceof IBodyElement);
        return BodyContainerFactory.getBodyContainer(((IBodyElement)run.getParent()).getBody());
    }

    public static BodyContainer getBodyContainer(IterableTemplate iterableTemplate) {
        return BodyContainerFactory.getBodyContainer(iterableTemplate.getStartRun());
    }
}

