/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ParagraphUtils;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.XWPFSection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class CellBodyContainer
implements BodyContainer {
    private XWPFTableCell cell;

    public CellBodyContainer(XWPFTableCell cell) {
        this.cell = cell;
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            int indexOf;
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                indexOf = this.cell.getTables().indexOf(bodyElements.get(pos));
                List tables = (List)ReflectionUtils.getValue("tables", this.cell);
                tables.remove(indexOf);
                this.cell.getCTTc().removeTbl(indexOf);
            }
            if (type == BodyElementType.PARAGRAPH) {
                indexOf = this.cell.getParagraphs().indexOf(bodyElements.get(pos));
                List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.cell);
                paragraphs.remove(indexOf);
                this.cell.getCTTc().removeP(indexOf);
            }
            bodyElements.remove(pos);
        }
    }

    @Override
    public void setParagraph(XWPFParagraph p, int pos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.cell);
        paragraphs.set(pos, p);
        CTTc ctTc = this.cell.getCTTc();
        ctTc.setPArray(pos, p.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.cell;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        List tables = (List)ReflectionUtils.getValue("tables", this.cell);
        tables.set(pos, table);
        this.cell.getCTTc().setTblArray(pos, table.getCTTbl());
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        int i;
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        XWPFTable table = this.insertNewTbl(cursor);
        List rows = table.getRows();
        for (i = 0; i < rows.size(); ++i) {
            table.removeRow(i);
        }
        for (i = 0; i < row; ++i) {
            XWPFTableRow tabRow = table.getRow(i) == null ? table.createRow() : table.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
        return table;
    }

    @Override
    public void clearPlaceholder(XWPFRun run) {
        IRunBody parent = run.getParent();
        run.setText("", 0);
        if (parent instanceof XWPFParagraph) {
            int lastPos;
            int pos;
            String paragraphText = ParagraphUtils.trimLine((XWPFParagraph)parent);
            boolean havePictures = ParagraphUtils.havePictures((XWPFParagraph)parent);
            if ("".equals(paragraphText) && !havePictures && this.canRemoveParagraph(pos = this.getPosOfParagraph((XWPFParagraph)parent), lastPos = this.cell.getBodyElements().size() - 1)) {
                this.removeBodyElement(pos);
            }
        }
    }

    private boolean canRemoveParagraph(int pos, int lastPos) {
        return pos < lastPos || pos > 0 && ((IBodyElement)this.cell.getBodyElements().get(pos - 1)).getElementType() == BodyElementType.PARAGRAPH;
    }

    @Override
    public XWPFSection closelySectPr(IBodyElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int elementPageWidth(IBodyElement element) {
        return this.cell.getWidth();
    }
}

