/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm;

import com.dieselpoint.norm.Database;
import com.dieselpoint.norm.DbException;
import com.dieselpoint.norm.latency.LatencyTimer;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;

public class Transaction
implements Closeable {
    private Connection con;
    private Database db;
    private long maxLatency;

    Transaction() {
        this.maxLatency = -1L;
    }

    Transaction(Database db, Connection con) throws DbException {
        this.db = db;
        this.con = con;
        this.maxLatency = db.getMaxLatencyMillis();
        this.setConnection(con);
    }

    void setConnection(Connection con) throws DbException {
        this.con = con;
        try {
            con.setAutoCommit(false);
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
    }

    public void commit() {
        try {
            LatencyTimer myLatencyTimer = new LatencyTimer(this);
            this.con.commit();
            myLatencyTimer.stop(this);
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
        finally {
            try {
                this.con.close();
            }
            catch (Throwable t) {
                throw new DbException(t);
            }
        }
    }

    public void rollback() {
        try {
            this.con.rollback();
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
        finally {
            try {
                this.con.close();
            }
            catch (Throwable t) {
                throw new DbException(t);
            }
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    @Override
    public void close() throws IOException {
        this.commit();
    }

    public Database getDatabase() {
        return this.db;
    }

    public Transaction maxLatency(long millis) {
        this.maxLatency = millis;
        return this;
    }

    public long getMaxLatencyMillis() {
        return this.maxLatency;
    }
}

