/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.latency;

import com.dieselpoint.norm.Transaction;
import java.util.Arrays;

public class DbLatencyWarning {
    public final long maxAcceptableLatency;
    public final long actualLatency;
    public final String cause;
    public final String offendingStatement;

    protected DbLatencyWarning(long maxAcceptableLatency, long actualLatency, String cause) {
        this.maxAcceptableLatency = maxAcceptableLatency;
        this.actualLatency = actualLatency;
        this.cause = cause;
        this.offendingStatement = this.getOffendingStatement();
    }

    public DbLatencyWarning(long maxAcceptableLatency, long actualLatency, String theNaughtySql, Object[] theNaughtyArgs) {
        this(maxAcceptableLatency, actualLatency, "SQL:" + theNaughtySql + ", SQL_Args:" + Arrays.deepToString(theNaughtyArgs));
    }

    public DbLatencyWarning(long maxAcceptableLatency, long actualLatency, Transaction theNaughtyTransaction) {
        this(maxAcceptableLatency, actualLatency, "Transaction commit exceeded threshold:");
    }

    private String getOffendingStatement() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 2; i < elements.length; ++i) {
            StackTraceElement e = elements[i];
            if (e.getClassName().startsWith("com.dieselpoint.norm.")) continue;
            return e.toString();
        }
        return "[Unknown]";
    }

    public String toString() {
        if (this.maxAcceptableLatency == 0L) {
            return "Database Latency was: " + this.actualLatency + "ms, at " + this.offendingStatement + ". " + this.cause;
        }
        return "Database Latency was: " + this.actualLatency + "ms, at " + this.offendingStatement + ", versus max acceptable: " + this.maxAcceptableLatency + "ms. Caused by " + this.cause;
    }
}

