/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.sqlmakers;

import com.dieselpoint.norm.Query;
import com.dieselpoint.norm.sqlmakers.PojoInfo;
import com.dieselpoint.norm.sqlmakers.StandardPojoInfo;
import com.dieselpoint.norm.sqlmakers.StandardSqlMaker;
import java.util.Objects;

public class MySqlMaker
extends StandardSqlMaker {
    @Override
    public String getUpsertSql(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        return String.format(((StandardPojoInfo)pojoInfo).upsertSql, Objects.requireNonNullElse(query.getTable(), ((StandardPojoInfo)pojoInfo).table));
    }

    @Override
    public Object[] getUpsertArgs(Query query, Object row) {
        Object[] args = super.getInsertArgs(query, row);
        int count = args.length;
        Object[] upsertArgs = new Object[count * 2];
        System.arraycopy(args, 0, upsertArgs, 0, count);
        System.arraycopy(args, 0, upsertArgs, count, count);
        return upsertArgs;
    }

    @Override
    public void makeUpsertSql(StandardPojoInfo pojoInfo) {
        StringBuilder buf = new StringBuilder();
        buf.append(pojoInfo.insertSql);
        buf.append(" on duplicate key update ");
        boolean first = true;
        for (String colName : pojoInfo.insertColumnNames) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(colName);
            buf.append("=?");
        }
        pojoInfo.upsertSql = buf.toString();
    }

    @Override
    protected String getColType(Class<?> dataType, int length, int precision, int scale) {
        String colType = dataType.equals(Boolean.class) || dataType.equals(Boolean.TYPE) ? "tinyint" : super.getColType(dataType, length, precision, scale);
        return colType;
    }

    @Override
    public Object convertValue(Object value, String columnTypeName) {
        if ("TINYINT".equalsIgnoreCase(columnTypeName)) {
            value = (Integer)value == 1;
        }
        return value;
    }
}

