/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.sqlmakers;

import com.dieselpoint.norm.DbException;
import com.dieselpoint.norm.Query;
import com.dieselpoint.norm.Util;
import com.dieselpoint.norm.sqlmakers.PojoInfo;
import com.dieselpoint.norm.sqlmakers.Property;
import com.dieselpoint.norm.sqlmakers.SqlMaker;
import com.dieselpoint.norm.sqlmakers.StandardPojoInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;

public class StandardSqlMaker
implements SqlMaker {
    private static ConcurrentHashMap<Class<?>, StandardPojoInfo> map = new ConcurrentHashMap();

    @Override
    public StandardPojoInfo getPojoInfo(Class<?> rowClass) {
        StandardPojoInfo pi = map.get(rowClass);
        if (pi == null) {
            pi = new StandardPojoInfo(rowClass);
            map.put(rowClass, pi);
            this.makeInsertSql(pi);
            this.makeUpsertSql(pi);
            this.makeUpdateSql(pi);
            this.makeSelectColumns(pi);
        }
        return pi;
    }

    @Override
    public String getInsertSql(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        return String.format(((StandardPojoInfo)pojoInfo).insertSql, Objects.requireNonNullElse(query.getTable(), ((StandardPojoInfo)pojoInfo).table));
    }

    @Override
    public Object[] getInsertArgs(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        Object[] args = new Object[((StandardPojoInfo)pojoInfo).insertSqlArgCount];
        for (int i = 0; i < ((StandardPojoInfo)pojoInfo).insertSqlArgCount; ++i) {
            args[i] = ((StandardPojoInfo)pojoInfo).getValue(row, ((StandardPojoInfo)pojoInfo).insertColumnNames[i]);
        }
        return args;
    }

    @Override
    public String getUpdateSql(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        if (((StandardPojoInfo)pojoInfo).primaryKeyNames.size() == 0) {
            throw new DbException("No primary keys specified in the row. Use the @Id annotation.");
        }
        return String.format(((StandardPojoInfo)pojoInfo).updateSql, Objects.requireNonNullElse(query.getTable(), ((StandardPojoInfo)pojoInfo).table));
    }

    @Override
    public Object[] getUpdateArgs(Query query, Object row) {
        int i;
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        int numKeys = ((StandardPojoInfo)pojoInfo).primaryKeyNames.size();
        Object[] args = new Object[((StandardPojoInfo)pojoInfo).updateSqlArgCount];
        for (i = 0; i < ((StandardPojoInfo)pojoInfo).updateSqlArgCount - numKeys; ++i) {
            args[i] = ((StandardPojoInfo)pojoInfo).getValue(row, ((StandardPojoInfo)pojoInfo).updateColumnNames[i]);
        }
        for (i = 0; i < numKeys; ++i) {
            Object pk;
            args[((StandardPojoInfo)pojoInfo).updateSqlArgCount - (numKeys - i)] = pk = ((StandardPojoInfo)pojoInfo).getValue(row, ((StandardPojoInfo)pojoInfo).primaryKeyNames.get(i));
        }
        return args;
    }

    public void makeUpdateSql(StandardPojoInfo pojoInfo) {
        int i;
        ArrayList<String> cols = new ArrayList<String>();
        for (Property prop : pojoInfo.propertyMap.values()) {
            if (prop.isPrimaryKey || prop.isGenerated) continue;
            cols.add(prop.name);
        }
        pojoInfo.updateColumnNames = cols.toArray(new String[cols.size()]);
        pojoInfo.updateSqlArgCount = pojoInfo.updateColumnNames.length + pojoInfo.primaryKeyNames.size();
        StringBuilder buf = new StringBuilder();
        buf.append("update %s set ");
        for (i = 0; i < cols.size(); ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append((String)cols.get(i)).append("=?");
        }
        buf.append(" where ");
        for (i = 0; i < pojoInfo.primaryKeyNames.size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            buf.append(pojoInfo.primaryKeyNames.get(i)).append("=?");
        }
        pojoInfo.updateSql = buf.toString();
    }

    public void makeInsertSql(StandardPojoInfo pojoInfo) {
        ArrayList<String> cols = new ArrayList<String>();
        for (Property prop : pojoInfo.propertyMap.values()) {
            if (prop.isGenerated) continue;
            cols.add(prop.name);
        }
        pojoInfo.insertColumnNames = cols.toArray(new String[cols.size()]);
        pojoInfo.insertSqlArgCount = pojoInfo.insertColumnNames.length;
        pojoInfo.insertSql = "insert into %s (" + Util.join(pojoInfo.insertColumnNames) + ") values (" + Util.getQuestionMarks(pojoInfo.insertSqlArgCount) + ")";
    }

    public void makeUpsertSql(StandardPojoInfo pojoInfo) {
    }

    private void makeSelectColumns(StandardPojoInfo pojoInfo) {
        if (pojoInfo.propertyMap.isEmpty()) {
            pojoInfo.selectColumns = "*";
        } else {
            ArrayList<String> cols = new ArrayList<String>();
            for (Property prop : pojoInfo.propertyMap.values()) {
                cols.add(prop.name);
            }
            pojoInfo.selectColumns = Util.join(cols);
        }
    }

    @Override
    public String getSelectSql(Query query, Class<?> rowClass) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)rowClass);
        String columns = ((StandardPojoInfo)pojoInfo).selectColumns;
        String where = query.getWhere();
        String table = query.getTable();
        if (table == null) {
            table = ((StandardPojoInfo)pojoInfo).table;
        }
        String orderBy = query.getOrderBy();
        StringBuilder out = new StringBuilder();
        out.append("select ");
        out.append(columns);
        out.append(" from ");
        out.append(table);
        if (where != null) {
            out.append(" where ");
            out.append(where);
        }
        if (orderBy != null) {
            out.append(" order by ");
            out.append(orderBy);
        }
        return out.toString();
    }

    @Override
    public String getCreateTableSql(Class<?> clazz) {
        StringBuilder buf = new StringBuilder();
        PojoInfo pojoInfo = this.getPojoInfo((Class)clazz);
        buf.append("create table ");
        buf.append(((StandardPojoInfo)pojoInfo).table);
        buf.append(" (");
        boolean needsComma = false;
        for (Property prop : ((StandardPojoInfo)pojoInfo).propertyMap.values()) {
            if (needsComma) {
                buf.append(',');
            }
            needsComma = true;
            Column columnAnnot = prop.columnAnnotation;
            if (columnAnnot == null) {
                buf.append(prop.name);
                buf.append(" ");
                buf.append(this.getColType(prop.dataType, 255, 10, 2));
                if (!prop.isGenerated) continue;
                buf.append(" auto_increment");
                continue;
            }
            if (columnAnnot.columnDefinition() == null) {
                buf.append(columnAnnot.columnDefinition());
                continue;
            }
            buf.append(prop.name);
            buf.append(" ");
            buf.append(this.getColType(prop.dataType, columnAnnot.length(), columnAnnot.precision(), columnAnnot.scale()));
            if (prop.isGenerated) {
                buf.append(" auto_increment");
            }
            if (columnAnnot.unique()) {
                buf.append(" unique");
            }
            if (columnAnnot.nullable()) continue;
            buf.append(" not null");
        }
        if (((StandardPojoInfo)pojoInfo).primaryKeyNames.size() > 0) {
            buf.append(", primary key (");
            for (int i = 0; i < ((StandardPojoInfo)pojoInfo).primaryKeyNames.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(((StandardPojoInfo)pojoInfo).primaryKeyNames.get(i));
            }
            buf.append(")");
        }
        buf.append(")");
        return buf.toString();
    }

    protected String getColType(Class<?> dataType, int length, int precision, int scale) {
        Object colType = dataType.equals(Integer.class) || dataType.equals(Integer.TYPE) ? "integer" : (dataType.equals(Long.class) || dataType.equals(Long.TYPE) ? "bigint" : (dataType.equals(Double.class) || dataType.equals(Double.TYPE) ? "double" : (dataType.equals(Float.class) || dataType.equals(Float.TYPE) ? "float" : (dataType.equals(BigDecimal.class) ? "decimal(" + precision + "," + scale + ")" : (dataType.equals(Date.class) ? "datetime" : "varchar(" + length + ")")))));
        return colType;
    }

    @Override
    public Object convertValue(Object value, String columnTypeName) {
        return value;
    }

    @Override
    public String getDeleteSql(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        String table = query.getTable();
        if (table == null && (table = ((StandardPojoInfo)pojoInfo).table) == null) {
            throw new DbException("You must specify a table name");
        }
        StringBuilder builder = new StringBuilder("delete from ");
        builder.append(table).append(" where ");
        for (int i = 0; i < ((StandardPojoInfo)pojoInfo).primaryKeyNames.size(); ++i) {
            if (i > 0) {
                builder.append(" and ");
            }
            builder.append(((StandardPojoInfo)pojoInfo).primaryKeyNames.get(i)).append("=?");
        }
        return builder.toString();
    }

    @Override
    public Object[] getDeleteArgs(Query query, Object row) {
        PojoInfo pojoInfo = this.getPojoInfo((Class)row.getClass());
        Object[] args = new Object[((StandardPojoInfo)pojoInfo).primaryKeyNames.size()];
        for (int i = 0; i < ((StandardPojoInfo)pojoInfo).primaryKeyNames.size(); ++i) {
            Object primaryKeyValue;
            args[i] = primaryKeyValue = ((StandardPojoInfo)pojoInfo).getValue(row, ((StandardPojoInfo)pojoInfo).primaryKeyNames.get(i));
        }
        return args;
    }

    @Override
    public String getUpsertSql(Query query, Object row) {
        String msg = "There's no standard upsert implemention. There is one in the MySql driver, though,so if you're using MySql, call Database.setSqlMaker(new MySqlMaker()); Or roll your own.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Object[] getUpsertArgs(Query query, Object row) {
        throw new UnsupportedOperationException();
    }
}

