/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.fsm.dsl;

import com.digitalpetri.fsm.Fsm;
import com.digitalpetri.fsm.StrictMachine;
import com.digitalpetri.fsm.dsl.ActionFromBuilder;
import com.digitalpetri.fsm.dsl.ActionProxy;
import com.digitalpetri.fsm.dsl.ActionToBuilder;
import com.digitalpetri.fsm.dsl.Transition;
import com.digitalpetri.fsm.dsl.TransitionAction;
import com.digitalpetri.fsm.dsl.TransitionBuilder;
import com.digitalpetri.fsm.dsl.ViaBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class FsmBuilder<S extends Enum<S>, E> {
    private static final AtomicLong INSTANCE_ID = new AtomicLong(0L);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final List<Transition<S, E>> transitions = new ArrayList<Transition<S, E>>();
    private final LinkedList<TransitionAction<S, E>> transitionActions = new LinkedList();
    private ActionProxy<S, E> actionProxy = null;
    private final String loggerName;
    private final Map<String, String> mdc;
    private final Executor executor;
    private final Object userContext;

    public FsmBuilder() {
        this(StrictMachine.class.getName(), Map.of(), EXECUTOR_SERVICE, null);
    }

    public FsmBuilder(String loggerName, Map<String, String> mdc, Executor executor, Object userContext) {
        this.loggerName = loggerName;
        this.mdc = mdc;
        this.executor = executor;
        this.userContext = userContext;
    }

    public TransitionBuilder<S, E> when(S state) {
        return new TransitionBuilder<S, E>(state, this.transitions, this.transitionActions);
    }

    public ViaBuilder<S, E> onInternalTransition(S state) {
        return this.onTransitionFrom(state).to(state);
    }

    public ActionToBuilder<S, E> onTransitionTo(S state) {
        return this.onTransitionTo(s -> Objects.equals(s, state));
    }

    public ActionToBuilder<S, E> onTransitionTo(Predicate<S> filter) {
        return new ActionToBuilder<S, E>(filter, this.transitionActions);
    }

    public ActionFromBuilder<S, E> onTransitionFrom(S state) {
        return this.onTransitionFrom(s -> Objects.equals(s, state));
    }

    public ActionFromBuilder<S, E> onTransitionFrom(Predicate<S> filter) {
        return new ActionFromBuilder<S, E>(filter, this.transitionActions);
    }

    public void addTransition(Transition<S, E> transition) {
        this.transitions.add(transition);
    }

    public void addTransitionAction(TransitionAction<S, E> transitionAction) {
        this.transitionActions.add(transitionAction);
    }

    public void setActionProxy(ActionProxy<S, E> actionProxy) {
        this.actionProxy = actionProxy;
    }

    public Fsm<S, E> build(S initialState) {
        return new StrictMachine<S, E>(this.loggerName, this.mdc, this.executor, this.userContext, this.actionProxy, initialState, new ArrayList<Transition<S, E>>(this.transitions), new ArrayList<TransitionAction<S, E>>(this.transitionActions));
    }
}

