/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.fsm.dsl;

import com.digitalpetri.fsm.dsl.GuardBuilder;
import com.digitalpetri.fsm.dsl.PredicatedTransition;
import com.digitalpetri.fsm.dsl.Transition;
import com.digitalpetri.fsm.dsl.TransitionAction;
import com.digitalpetri.fsm.dsl.Transitions;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class TransitionBuilder<S extends Enum<S>, E> {
    private final S from;
    private final List<Transition<S, E>> transitions;
    private final LinkedList<TransitionAction<S, E>> transitionActions;

    TransitionBuilder(S from, List<Transition<S, E>> transitions, LinkedList<TransitionAction<S, E>> transitionActions) {
        this.from = from;
        this.transitions = transitions;
        this.transitionActions = transitionActions;
    }

    public TransitionTo<S, E> on(E event) {
        return to -> {
            PredicatedTransition<Enum, Object> transition = Transitions.fromInstanceViaInstance(this.from, event, to);
            this.transitions.add(transition);
            return new GuardBuilder<Enum, Object>(transition, this.transitionActions);
        };
    }

    public TransitionTo<S, E> on(Class<? extends E> eventClass) {
        return to -> {
            PredicatedTransition transition = Transitions.fromInstanceViaClass(this.from, eventClass, to);
            this.transitions.add(transition);
            return new GuardBuilder(transition, this.transitionActions);
        };
    }

    public TransitionTo<S, E> on(Predicate<E> eventFilter) {
        return to -> {
            PredicatedTransition transition = Transitions.fromInstanceViaDynamic(this.from, eventFilter, to);
            this.transitions.add(transition);
            return new GuardBuilder(transition, this.transitionActions);
        };
    }

    public TransitionTo<S, E> onAny() {
        return this.on((E e) -> true);
    }

    public static interface TransitionTo<S, E> {
        public GuardBuilder<S, E> transitionTo(S var1);
    }
}

