/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.netty.fsm;

import com.digitalpetri.fsm.FsmContext;
import com.digitalpetri.fsm.dsl.ActionContext;
import com.digitalpetri.fsm.dsl.FsmBuilder;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmConfigBuilder;
import com.digitalpetri.netty.fsm.CompletionBuilders;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.Scheduler;
import com.digitalpetri.netty.fsm.State;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ChannelFsmFactory {
    private final ChannelFsmConfig config;

    public ChannelFsmFactory(ChannelFsmConfig config) {
        this.config = config;
    }

    public ChannelFsm newChannelFsm() {
        return this.newChannelFsm(State.NotConnected);
    }

    ChannelFsm newChannelFsm(State initialState) {
        FsmBuilder builder = new FsmBuilder(this.config.getLoggerName(), this.config.getLoggingContext(), this.config.getExecutor(), this.config.getUserContext());
        ChannelFsmFactory.configureChannelFsm((FsmBuilder<State, Event>)builder, this.config);
        return new ChannelFsm((FsmBuilder<State, Event>)builder, initialState);
    }

    public static ChannelFsm newChannelFsm(ChannelFsmConfig config) {
        return new ChannelFsmFactory(config).newChannelFsm();
    }

    private static void configureChannelFsm(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        ChannelFsmFactory.configureNotConnectedState(fb, config);
        ChannelFsmFactory.configureIdleState(fb, config);
        ChannelFsmFactory.configureConnectingState(fb, config);
        ChannelFsmFactory.configureConnectedState(fb, config);
        ChannelFsmFactory.configureDisconnectingState(fb, config);
        ChannelFsmFactory.configureReconnectWaitState(fb, config);
        ChannelFsmFactory.configureReconnectingState(fb, config);
    }

    private static void configureNotConnectedState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        fb.when((Enum)State.NotConnected).on(Event.Connect.class).transitionTo((Object)State.Connecting);
        fb.onInternalTransition((Enum)State.NotConnected).via(Event.Disconnect.class).execute(ctx -> {
            Event.Disconnect disconnectEvent = (Event.Disconnect)ctx.event();
            config.getExecutor().execute(() -> disconnectEvent.disconnectFuture.complete(null));
        });
        fb.onInternalTransition((Enum)State.NotConnected).via(Event.GetChannel.class).execute(ctx -> {
            Event.GetChannel getChannelEvent = (Event.GetChannel)ctx.event();
            config.getExecutor().execute(() -> getChannelEvent.channelFuture.completeExceptionally(new Exception("not connected")));
        });
    }

    private static void configureIdleState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        fb.when((Enum)State.Idle).on(Event.Connect.class).transitionTo((Object)State.Reconnecting);
        fb.when((Enum)State.Idle).on(Event.GetChannel.class).transitionTo((Object)State.Reconnecting);
        fb.when((Enum)State.Idle).on(Event.Disconnect.class).transitionTo((Object)State.NotConnected);
        fb.onTransitionFrom((Enum)State.Idle).to((Enum)State.NotConnected).via(Event.Disconnect.class).execute(ctx -> {
            Event.Disconnect disconnect = (Event.Disconnect)ctx.event();
            config.getExecutor().execute(() -> disconnect.disconnectFuture.complete(null));
        });
    }

    private static void configureConnectingState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        if (config.isPersistent()) {
            if (config.isLazy()) {
                fb.when((Enum)State.Connecting).on(Event.ConnectFailure.class).transitionTo((Object)State.Idle);
            } else {
                fb.when((Enum)State.Connecting).on(Event.ConnectFailure.class).transitionTo((Object)State.ReconnectWait);
            }
        } else {
            fb.when((Enum)State.Connecting).on(Event.ConnectFailure.class).transitionTo((Object)State.NotConnected);
        }
        fb.when((Enum)State.Connecting).on(Event.ConnectSuccess.class).transitionTo((Object)State.Connected);
        fb.onTransitionTo((Enum)State.Connecting).from(s -> s != State.Connecting).via(e -> e.getClass() == Event.Connect.class).execute(ctx -> {
            ChannelFsm.ConnectFuture cf = new ChannelFsm.ConnectFuture();
            ChannelFsm.KEY_CF.set((FsmContext)ctx, (Object)cf);
            ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config);
            ChannelFsmFactory.connect((ActionContext<State, Event>)ctx, config);
        });
        fb.onInternalTransition((Enum)State.Connecting).via(Event.Connect.class).execute(ctx -> ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Connecting).via(Event.GetChannel.class).execute(ctx -> ChannelFsmFactory.handleGetChannelEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Connecting).via(Event.Disconnect.class).execute(ctx -> ctx.shelveEvent((Object)((Event)ctx.event())));
        fb.onTransitionFrom((Enum)State.Connecting).to(s -> s != State.Connecting).viaAny().execute(FsmContext::processShelvedEvents);
        fb.onTransitionFrom((Enum)State.Connecting).to(s -> s != State.Connecting).via(Event.ConnectFailure.class).execute(ctx -> ChannelFsmFactory.handleConnectFailureEvent((ActionContext<State, Event>)ctx, config));
    }

    private static void configureConnectedState(FsmBuilder<State, Event> fb, final ChannelFsmConfig config) {
        final Logger logger = LoggerFactory.getLogger((String)config.getLoggerName());
        fb.when((Enum)State.Connected).on(Event.Disconnect.class).transitionTo((Object)State.Disconnecting);
        if (config.isLazy()) {
            fb.when((Enum)State.Connected).on(e -> e.getClass() == Event.ChannelInactive.class || e.getClass() == Event.KeepAliveFailure.class).transitionTo((Object)State.Idle);
        } else {
            fb.when((Enum)State.Connected).on(e -> e.getClass() == Event.ChannelInactive.class || e.getClass() == Event.KeepAliveFailure.class).transitionTo((Object)State.ReconnectWait);
        }
        fb.onTransitionTo((Enum)State.Connected).from(s -> s != State.Connected).via(Event.ConnectSuccess.class).execute(ctx -> {
            Event.ConnectSuccess event = (Event.ConnectSuccess)ctx.event();
            Channel channel = event.channel;
            if (config.getMaxIdleSeconds() > 0) {
                channel.pipeline().addFirst(new ChannelHandler[]{new IdleStateHandler(config.getMaxIdleSeconds(), 0, 0)});
            }
            channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelInactive(ChannelHandlerContext channelContext) throws Exception {
                    config.getLoggingContext().forEach(MDC::put);
                    try {
                        logger.debug("channelInactive() local={}, remote={}", (Object)channelContext.channel().localAddress(), (Object)channelContext.channel().remoteAddress());
                    }
                    finally {
                        config.getLoggingContext().keySet().forEach(MDC::remove);
                    }
                    if (ctx.currentState() == State.Connected) {
                        ctx.fireEvent((Object)new Event.ChannelInactive());
                    }
                    super.channelInactive(channelContext);
                }

                public void exceptionCaught(ChannelHandlerContext channelContext, Throwable cause) {
                    config.getLoggingContext().forEach(MDC::put);
                    try {
                        logger.debug("exceptionCaught() local={}, remote={}", new Object[]{channelContext.channel().localAddress(), channelContext.channel().remoteAddress(), cause});
                    }
                    finally {
                        config.getLoggingContext().keySet().forEach(MDC::remove);
                    }
                    if (ctx.currentState() == State.Connected) {
                        channelContext.close();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void userEventTriggered(ChannelHandlerContext channelContext, Object evt) throws Exception {
                    IdleState idleState;
                    if (evt instanceof IdleStateEvent && (idleState = ((IdleStateEvent)evt).state()) == IdleState.READER_IDLE) {
                        config.getLoggingContext().forEach(MDC::put);
                        try {
                            logger.debug("channel idle, maxIdleSeconds={}", (Object)config.getMaxIdleSeconds());
                        }
                        finally {
                            config.getLoggingContext().keySet().forEach(MDC::remove);
                        }
                        ctx.fireEvent((Object)new Event.ChannelIdle());
                    }
                    super.userEventTriggered(channelContext, evt);
                }
            }});
            ChannelFsm.ConnectFuture cf = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get((FsmContext)ctx);
            if (cf != null) {
                config.getExecutor().execute(() -> cf.future.complete(channel));
            }
        });
        fb.onInternalTransition((Enum)State.Connected).via(Event.Connect.class).execute(ctx -> ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Connected).via(Event.GetChannel.class).execute(ctx -> ChannelFsmFactory.handleGetChannelEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Connected).via(Event.ChannelIdle.class).execute(ctx -> {
            ChannelFsm.ConnectFuture cf = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get((FsmContext)ctx);
            cf.future.thenAcceptAsync(ch -> {
                CompletableFuture<Void> keepAliveFuture = config.getChannelActions().keepAlive((FsmContext<State, Event>)ctx, (Channel)ch);
                keepAliveFuture.whenComplete((v, ex) -> {
                    if (ex != null) {
                        ctx.fireEvent((Object)new Event.KeepAliveFailure((Throwable)ex));
                    }
                });
            }, config.getExecutor());
        });
        fb.onTransitionFrom((Enum)State.Connected).to(s -> s == State.Idle || s == State.ReconnectWait).via(Event.KeepAliveFailure.class).execute(ctx -> {
            ChannelFsm.ConnectFuture cf = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get((FsmContext)ctx);
            cf.future.thenAccept(ChannelOutboundInvoker::close);
        });
    }

    private static void configureDisconnectingState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        fb.when((Enum)State.Disconnecting).on(Event.DisconnectSuccess.class).transitionTo((Object)State.NotConnected);
        fb.onTransitionTo((Enum)State.Disconnecting).from((Enum)State.Connected).via(Event.Disconnect.class).execute(ctx -> {
            ChannelFsm.DisconnectFuture df = new ChannelFsm.DisconnectFuture();
            ChannelFsm.KEY_DF.set((FsmContext)ctx, (Object)df);
            Event.Disconnect event = (Event.Disconnect)ctx.event();
            CompletionBuilders.completeAsync(event.disconnectFuture, config.getExecutor()).with(df.future);
            ChannelFsmFactory.disconnect((ActionContext<State, Event>)ctx, config);
        });
        fb.onInternalTransition((Enum)State.Disconnecting).via(e -> e.getClass() == Event.Connect.class || e.getClass() == Event.GetChannel.class).execute(ctx -> ctx.shelveEvent((Object)((Event)ctx.event())));
        fb.onInternalTransition((Enum)State.Disconnecting).via(Event.Disconnect.class).execute(ctx -> {
            ChannelFsm.DisconnectFuture df = (ChannelFsm.DisconnectFuture)ChannelFsm.KEY_DF.get((FsmContext)ctx);
            if (df != null) {
                Event.Disconnect event = (Event.Disconnect)ctx.event();
                CompletionBuilders.completeAsync(event.disconnectFuture, config.getExecutor()).with(df.future);
            }
        });
        fb.onTransitionFrom((Enum)State.Disconnecting).to(s -> s != State.Disconnecting).via(Event.DisconnectSuccess.class).execute(ctx -> {
            ChannelFsm.DisconnectFuture df = (ChannelFsm.DisconnectFuture)ChannelFsm.KEY_DF.remove((FsmContext)ctx);
            if (df != null) {
                config.getExecutor().execute(() -> df.future.complete(null));
            }
        });
        fb.onTransitionFrom((Enum)State.Disconnecting).to(s -> s != State.Disconnecting).viaAny().execute(FsmContext::processShelvedEvents);
    }

    private static void configureReconnectWaitState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        fb.when((Enum)State.ReconnectWait).on(Event.ReconnectDelayElapsed.class).transitionTo((Object)State.Reconnecting);
        fb.when((Enum)State.ReconnectWait).on(Event.Disconnect.class).transitionTo((Object)State.NotConnected);
        fb.onTransitionTo((Enum)State.ReconnectWait).from((Enum)State.Reconnecting).via(Event.ConnectFailure.class).execute(ctx -> ChannelFsmFactory.handleConnectFailureEvent((ActionContext<State, Event>)ctx, config));
        fb.onTransitionTo((Enum)State.ReconnectWait).from(s -> s != State.ReconnectWait).viaAny().execute(ctx -> {
            ChannelFsm.KEY_CF.set((FsmContext)ctx, (Object)new ChannelFsm.ConnectFuture());
            Long delay = (Long)ChannelFsm.KEY_RD.get((FsmContext)ctx);
            delay = delay == null ? Long.valueOf(1L) : Long.valueOf(Math.min((long)ChannelFsmFactory.getMaxReconnectDelay(config), delay << 1));
            ChannelFsm.KEY_RD.set((FsmContext)ctx, (Object)delay);
            Scheduler.Cancellable reconnectDelayFuture = config.getScheduler().schedule(() -> ctx.fireEvent((Object)new Event.ReconnectDelayElapsed()), delay, TimeUnit.SECONDS);
            ChannelFsm.KEY_RDF.set((FsmContext)ctx, (Object)reconnectDelayFuture);
        });
        fb.onInternalTransition((Enum)State.ReconnectWait).via(Event.Connect.class).execute(ctx -> ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.ReconnectWait).via(Event.GetChannel.class).execute(ctx -> {
            Event.GetChannel event = (Event.GetChannel)ctx.event();
            if (event.waitForReconnect) {
                ChannelFsmFactory.handleGetChannelEvent((ActionContext<State, Event>)ctx, config);
            } else {
                config.getExecutor().execute(() -> event.channelFuture.completeExceptionally(new Exception("not reconnected")));
            }
        });
        fb.onTransitionFrom((Enum)State.ReconnectWait).to((Enum)State.NotConnected).via(Event.Disconnect.class).execute(ctx -> {
            ChannelFsm.ConnectFuture connectFuture = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.remove((FsmContext)ctx);
            if (connectFuture != null) {
                config.getExecutor().execute(() -> connectFuture.future.completeExceptionally(new Exception("client disconnected")));
            }
            ChannelFsm.KEY_RD.remove((FsmContext)ctx);
            Scheduler.Cancellable reconnectDelayCancellable = (Scheduler.Cancellable)ChannelFsm.KEY_RDF.remove((FsmContext)ctx);
            if (reconnectDelayCancellable != null) {
                reconnectDelayCancellable.cancel();
            }
            Event.Disconnect disconnect = (Event.Disconnect)ctx.event();
            config.getExecutor().execute(() -> disconnect.disconnectFuture.complete(null));
        });
    }

    private static void configureReconnectingState(FsmBuilder<State, Event> fb, ChannelFsmConfig config) {
        fb.when((Enum)State.Reconnecting).on(Event.ConnectFailure.class).transitionTo((Object)State.ReconnectWait);
        fb.when((Enum)State.Reconnecting).on(Event.ConnectSuccess.class).transitionTo((Object)State.Connected);
        fb.onTransitionTo((Enum)State.Reconnecting).from((Enum)State.ReconnectWait).via(Event.ReconnectDelayElapsed.class).execute(ctx -> ChannelFsmFactory.connect((ActionContext<State, Event>)ctx, config));
        fb.onTransitionTo((Enum)State.Reconnecting).from((Enum)State.Idle).via(e -> e.getClass() == Event.Connect.class || e.getClass() == Event.GetChannel.class).execute(ctx -> {
            ChannelFsm.ConnectFuture cf = new ChannelFsm.ConnectFuture();
            ChannelFsm.KEY_CF.set((FsmContext)ctx, (Object)cf);
            Event event = (Event)ctx.event();
            if (event instanceof Event.Connect) {
                ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config);
            } else if (event instanceof Event.GetChannel) {
                ChannelFsmFactory.handleGetChannelEvent((ActionContext<State, Event>)ctx, config);
            }
            ChannelFsmFactory.connect((ActionContext<State, Event>)ctx, config);
        });
        fb.onInternalTransition((Enum)State.Reconnecting).via(Event.Connect.class).execute(ctx -> ChannelFsmFactory.handleConnectEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Reconnecting).via(Event.GetChannel.class).execute(ctx -> ChannelFsmFactory.handleGetChannelEvent((ActionContext<State, Event>)ctx, config));
        fb.onInternalTransition((Enum)State.Reconnecting).via(Event.Disconnect.class).execute(ctx -> ctx.shelveEvent((Object)((Event)ctx.event())));
        fb.onTransitionFrom((Enum)State.Reconnecting).to(s -> s != State.Reconnecting).viaAny().execute(FsmContext::processShelvedEvents);
        fb.onTransitionFrom((Enum)State.Reconnecting).to((Enum)State.Connected).via(Event.ConnectSuccess.class).execute(ctx -> {
            ChannelFsm.KEY_RD.remove((FsmContext)ctx);
            ChannelFsm.KEY_RDF.remove((FsmContext)ctx);
        });
    }

    private static void connect(ActionContext<State, Event> ctx, ChannelFsmConfig config) {
        config.getExecutor().execute(() -> config.getChannelActions().connect((FsmContext<State, Event>)ctx).whenComplete((channel, ex) -> {
            if (channel != null) {
                ctx.fireEvent((Object)new Event.ConnectSuccess((Channel)channel));
            } else {
                ctx.fireEvent((Object)new Event.ConnectFailure((Throwable)ex));
            }
        }));
    }

    private static void disconnect(ActionContext<State, Event> ctx, ChannelFsmConfig config) {
        ChannelFsm.ConnectFuture connectFuture = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get(ctx);
        if (connectFuture != null && connectFuture.future.isDone()) {
            config.getExecutor().execute(() -> {
                CompletableFuture<Void> disconnectFuture = config.getChannelActions().disconnect((FsmContext<State, Event>)ctx, connectFuture.future.getNow(null));
                disconnectFuture.whenComplete((v, ex) -> ctx.fireEvent((Object)new Event.DisconnectSuccess()));
            });
        } else {
            ctx.fireEvent((Object)new Event.DisconnectSuccess());
        }
    }

    private static void handleConnectEvent(ActionContext<State, Event> ctx, ChannelFsmConfig config) {
        CompletableFuture<Channel> channelFuture = ((ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get(ctx)).future;
        Event.Connect connectEvent = (Event.Connect)ctx.event();
        CompletionBuilders.completeAsync(connectEvent.channelFuture, config.getExecutor()).with(channelFuture);
    }

    private static void handleGetChannelEvent(ActionContext<State, Event> ctx, ChannelFsmConfig config) {
        CompletableFuture<Channel> channelFuture = ((ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.get(ctx)).future;
        Event.GetChannel getChannelEvent = (Event.GetChannel)ctx.event();
        CompletionBuilders.completeAsync(getChannelEvent.channelFuture, config.getExecutor()).with(channelFuture);
    }

    private static void handleConnectFailureEvent(ActionContext<State, Event> ctx, ChannelFsmConfig config) {
        ChannelFsm.ConnectFuture cf = (ChannelFsm.ConnectFuture)ChannelFsm.KEY_CF.remove(ctx);
        if (cf != null) {
            Event.ConnectFailure connectFailureEvent = (Event.ConnectFailure)ctx.event();
            config.getExecutor().execute(() -> cf.future.completeExceptionally(connectFailureEvent.failure));
        }
    }

    private static int getMaxReconnectDelay(ChannelFsmConfig config) {
        int highestOneBit;
        int maxReconnectDelay = config.getMaxReconnectDelaySeconds();
        if (maxReconnectDelay < 1) {
            maxReconnectDelay = ChannelFsmConfigBuilder.DEFAULT_MAX_RECONNECT_DELAY_SECONDS;
        }
        if (maxReconnectDelay == (highestOneBit = Integer.highestOneBit(maxReconnectDelay))) {
            return maxReconnectDelay;
        }
        return highestOneBit << 1;
    }
}

