/*
 * Decompiled with CFR 0.152.
 */
package com.diogonunes.jcdp.bw;

import com.diogonunes.jcdp.bw.api.AbstractPrinter;
import com.diogonunes.jcdp.bw.api.IPrinter;
import com.diogonunes.jcdp.bw.impl.TerminalPrinter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Printer
implements IPrinter {
    private AbstractPrinter _impl;

    public Printer(AbstractPrinter implementation) {
        this.setImpl(implementation);
    }

    public Printer(Builder b) throws IllegalArgumentException {
        switch (b._type) {
            case TERM: {
                this.setImpl(new TerminalPrinter.Builder(b._level, b._tsFlag).withFormat(b._dateFormat).build());
                break;
            }
            case FILE: {
                throw new IllegalArgumentException("This type of printer isn't supported... yet!");
            }
            default: {
                throw new IllegalArgumentException("Unknown type!");
            }
        }
    }

    private AbstractPrinter getImpl() {
        return this._impl;
    }

    private void setImpl(AbstractPrinter impl) {
        this._impl = impl;
    }

    @Override
    public int getLevel() {
        return this.getImpl().getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.getImpl().setLevel(level);
    }

    @Override
    public String getDateFormatted() {
        return this.getImpl().getDateFormatted();
    }

    @Override
    public Date getDate() {
        return this.getImpl().getDate();
    }

    @Override
    public void printTimestamp() {
        this.getImpl().printTimestamp();
    }

    @Override
    public void printErrorTimestamp() {
        this.getImpl().printErrorTimestamp();
    }

    @Override
    public void print(Object msg) {
        this.getImpl().print(msg);
    }

    @Override
    public void println(Object msg) {
        this.getImpl().println(msg);
    }

    @Override
    public void errorPrint(Object msg) {
        this.getImpl().errorPrint(msg);
    }

    @Override
    public void errorPrintln(Object msg) {
        this.getImpl().errorPrintln(msg);
    }

    @Override
    public void debugPrint(Object msg) {
        this.getImpl().debugPrint(msg);
    }

    @Override
    public void debugPrint(Object msg, int level) {
        this.getImpl().debugPrint(msg, level);
    }

    @Override
    public void debugPrintln(Object msg) {
        this.getImpl().debugPrintln(msg);
    }

    @Override
    public void debugPrintln(Object msg, int level) {
        this.getImpl().debugPrintln(msg, level);
    }

    public String toString() {
        return this.getImpl().toString();
    }

    public static class Builder {
        private Types _type;
        private int _level = 0;
        private boolean _tsFlag = true;
        private DateFormat _dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

        public Builder(Types type) {
            this._type = type;
        }

        public Builder level(int level) {
            this._level = level;
            return this;
        }

        public Builder timestamping(boolean flag) {
            this._tsFlag = flag;
            return this;
        }

        public Builder withFormat(DateFormat df) {
            this._dateFormat = df;
            return this;
        }

        public Printer build() throws IllegalArgumentException {
            return new Printer(this);
        }
    }

    public static enum Types {
        TERM,
        FILE;

    }
}

