/*
 * Decompiled with CFR 0.152.
 */
package com.diogonunes.jcdp.bw.impl;

import com.diogonunes.jcdp.bw.api.AbstractPrinter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class TerminalPrinter
extends AbstractPrinter {
    public TerminalPrinter() {
        this(new Builder(0, false));
    }

    public TerminalPrinter(Builder builder) {
        this.setLevel(builder._level);
        this.setTimestamping(builder._timestampFlag);
        this.setDateFormat(builder._dateFormat);
    }

    @Override
    public void printTimestamp() {
        System.out.print(this.getDateFormatted() + " ");
    }

    @Override
    public void printErrorTimestamp() {
        System.err.print(this.getDateFormatted() + " ");
    }

    @Override
    public void print(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        }
        System.out.print(msg);
    }

    @Override
    public void println(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        }
        System.out.println(msg);
    }

    @Override
    public void errorPrint(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printErrorTimestamp();
        }
        System.err.print(msg);
    }

    @Override
    public void errorPrintln(Object msg) {
        if (this.isLoggingTimestamps()) {
            this.printTimestamp();
        }
        System.err.println(msg);
    }

    @Override
    public void debugPrint(Object msg) {
        if (this.isLoggingDebug()) {
            this.print(msg);
        }
    }

    @Override
    public void debugPrint(Object msg, int level) {
        if (this.isLoggingDebug() && this.canPrint(level)) {
            this.print(msg);
        }
    }

    @Override
    public void debugPrintln(Object msg) {
        this.println(msg);
    }

    @Override
    public void debugPrintln(Object msg, int level) {
        if (this.canPrint(level)) {
            this.println(msg);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " | level: " + this.getLevel() + " | timestamping: " + this.isLoggingTimestamps();
    }

    public static class Builder {
        private int _level;
        private boolean _timestampFlag;
        private DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public Builder(int level, boolean tsFlag) {
            this._level = level;
            this._timestampFlag = tsFlag;
        }

        public Builder withFormat(DateFormat df) {
            this._dateFormat = df;
            return this;
        }

        public TerminalPrinter build() {
            return new TerminalPrinter(this);
        }
    }
}

