/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.ApiResponse;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.IndividualMembershipDataRedactionRequest;
import com.docusign.admin.model.IndividualUserDataRedactionResponse;
import com.docusign.admin.model.MemberGroupsResponse;
import com.docusign.admin.model.OrganizationsResponse;
import com.docusign.admin.model.PermissionsResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MemberGroupsResponse getGroups(UUID organizationId, UUID accountId) throws ApiException {
        return this.getGroups(organizationId, accountId, null);
    }

    public MemberGroupsResponse getGroups(UUID organizationId, UUID accountId, GetGroupsOptions options) throws ApiException {
        ApiResponse<MemberGroupsResponse> localVarResponse = this.getGroupsWithHttpInfo(organizationId, accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<MemberGroupsResponse> getGroupsWithHttpInfo(UUID organizationId, UUID accountId, GetGroupsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getGroups");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getGroups");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/groups".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start", options.start));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("take", options.take));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("end", options.end));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<MemberGroupsResponse> localVarReturnType = new GenericType<MemberGroupsResponse>(){};
        MemberGroupsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<MemberGroupsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationsResponse getOrganizations() throws ApiException {
        return this.getOrganizations(null);
    }

    public OrganizationsResponse getOrganizations(GetOrganizationsOptions options) throws ApiException {
        ApiResponse<OrganizationsResponse> localVarResponse = this.getOrganizationsWithHttpInfo(options);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationsResponse> getOrganizationsWithHttpInfo(GetOrganizationsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2/organizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", options.mode));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationsResponse> localVarReturnType = new GenericType<OrganizationsResponse>(){};
        OrganizationsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public PermissionsResponse getPermissions(UUID organizationId, UUID accountId) throws ApiException {
        ApiResponse<PermissionsResponse> localVarResponse = this.getPermissionsWithHttpInfo(organizationId, accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<PermissionsResponse> getPermissionsWithHttpInfo(UUID organizationId, UUID accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getPermissions");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPermissions");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/permissions".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        PermissionsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<PermissionsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public IndividualUserDataRedactionResponse redactIndividualMembershipData(UUID accountId, IndividualMembershipDataRedactionRequest requestModel) throws ApiException {
        ApiResponse<IndividualUserDataRedactionResponse> localVarResponse = this.redactIndividualMembershipDataWithHttpInfo(accountId, requestModel);
        return localVarResponse.getData();
    }

    public ApiResponse<IndividualUserDataRedactionResponse> redactIndividualMembershipDataWithHttpInfo(UUID accountId, IndividualMembershipDataRedactionRequest requestModel) throws ApiException {
        IndividualMembershipDataRedactionRequest localVarPostBody = requestModel;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling redactIndividualMembershipData");
        }
        if (requestModel == null) {
            throw new ApiException(400, "Missing the required parameter 'requestModel' when calling redactIndividualMembershipData");
        }
        String localVarPath = "/v2/data_redaction/accounts/{accountId}/user".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<IndividualUserDataRedactionResponse> localVarReturnType = new GenericType<IndividualUserDataRedactionResponse>(){};
        IndividualUserDataRedactionResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<IndividualUserDataRedactionResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetOrganizationsOptions {
        private String mode = null;

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }
    }

    public class GetGroupsOptions {
        private Integer start = null;
        private Integer take = null;
        private Integer end = null;

        public void setStart(Integer start) {
            this.start = start;
        }

        public Integer getStart() {
            return this.start;
        }

        public void setTake(Integer take) {
            this.take = take;
        }

        public Integer getTake() {
            return this.take;
        }

        public void setEnd(Integer end) {
            this.end = end;
        }

        public Integer getEnd() {
            return this.end;
        }
    }
}

