/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.client.auth;

import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.Pair;
import com.docusign.admin.client.RFC3339DateFormat;
import com.docusign.admin.client.auth.AccessTokenListener;
import com.docusign.admin.client.auth.Authentication;
import com.docusign.admin.client.auth.OAuthFlow;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OAuth
implements Authentication {
    static final int MILLIS_PER_SECOND = 1000;
    public static final String Scope_SIGNATURE = "signature";
    public static final String Scope_EXTENDED = "extended";
    public static final String Scope_IMPERSONATION = "impersonation";
    public static final String CODE = "code";
    public static final String TOKEN = "token";
    public static final String PRODUCTION_OAUTH_BASEPATH = "account.docusign.com";
    public static final String DEMO_OAUTH_BASEPATH = "account-d.docusign.com";
    public static final String GRANT_TYPE_JWT = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private String clientId = null;
    private String clientSecret = null;
    private String authorizationUrl = null;
    private String tokenUrl = null;
    private String redirectURI = null;
    private String scope = null;
    private OAuthFlow grantType = null;
    private volatile String accessToken;
    private volatile String refreshToken;
    private volatile String authCode;
    private volatile String jwtAssertion;
    private Long expirationTimeMillis;
    private AccessTokenListener accessTokenListener;
    private Client httpClient;

    public OAuth() {
    }

    public OAuth(Client httpClient) {
        this.httpClient = httpClient;
    }

    public OAuth(Client client, OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this.httpClient = client;
        this.setScope(scopes);
        this.setGrantType(flow);
        this.setAuthorizationUrl(authorizationUrl);
        this.setTokenUrl(tokenUrl);
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(ClientBuilder.newBuilder().build(), flow, authorizationUrl, tokenUrl, scopes);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            try {
                this.updateAccessToken();
            }
            catch (ApiException e) {
                this.accessToken = null;
            }
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    public synchronized void updateAccessToken() throws ApiException {
        OAuthToken oauthToken = null;
        try {
            switch (this.getGrantType()) {
                case accessCode: {
                    oauthToken = this.generateAccessToken();
                    break;
                }
                case jwt: {
                    oauthToken = this.requestJWTUserToken();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage());
        }
        if (oauthToken != null) {
            if (oauthToken.getAccessToken() == null) {
                throw new ApiException("Error while requesting an access token. No 'access_token' found.");
            }
            if (oauthToken.getExpiresIn() == null) {
                throw new ApiException("Error while requesting an access token. No 'expires_in' found.");
            }
            this.setAccessToken(oauthToken.getAccessToken(), (long)oauthToken.getExpiresIn());
            if (this.accessTokenListener != null) {
                this.accessTokenListener.notify(oauthToken);
            }
        } else {
            throw new ApiException("Error while requesting an access token. No accessTokenResponse object recieved, maybe a non HTTP 200 received?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthToken requestJWTUserToken() throws IllegalArgumentException, ApiException, IOException {
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("assertion", this.getJwtAssertion());
        form.put("grant_type", GRANT_TYPE_JWT);
        WebTarget target = this.httpClient.target(this.getTokenUrl());
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Entity<?> entity = this.serialize(null, form, "application/x-www-form-urlencoded");
        Response response = null;
        try {
            response = invocationBuilder.post(entity);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<OAuthToken> returnType = new GenericType<OAuthToken>(){};
            OAuthToken oAuthToken = this.deserialize(response, returnType);
            if (oAuthToken.getAccessToken() == null || "".equals(oAuthToken.getAccessToken()) || oAuthToken.getExpiresIn() <= 0L) {
                throw new ApiException("Error while requesting an access token: " + response.toString());
            }
            OAuthToken oAuthToken2 = oAuthToken;
            return oAuthToken2;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthToken generateAccessToken() throws ApiException, IOException {
        String clientId = this.getClientId();
        String clientSecret = this.getClientSecret();
        String code = this.getAuthCode();
        String clientStr = (clientId == null ? "" : clientId) + ":" + (clientSecret == null ? "" : clientSecret);
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put(CODE, code);
        form.put("grant_type", "authorization_code");
        WebTarget target = this.httpClient.target(this.getTokenUrl());
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(clientStr.getBytes(StandardCharsets.UTF_8)))).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Entity<?> entity = this.serialize(null, form, "application/x-www-form-urlencoded");
        Response response = null;
        try {
            response = invocationBuilder.post(entity);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<OAuthToken> returnType = new GenericType<OAuthToken>(){};
            OAuthToken oAuthToken = this.deserialize(response, returnType);
            return oAuthToken;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public void setExpirationTimeMillis(Long expirationTimeMillis) {
        this.expirationTimeMillis = expirationTimeMillis;
    }

    public synchronized void setAccessToken(String accessToken, Long expiresIn) {
        this.accessToken = accessToken;
        this.expirationTimeMillis = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuthFlow getGrantType() {
        return this.grantType;
    }

    public void setGrantType(OAuthFlow grantType) {
        this.grantType = grantType;
    }

    public String getJwtAssertion() {
        return this.jwtAssertion;
    }

    public void setJwtAssertion(String jwtAssertion) {
        this.jwtAssertion = jwtAssertion;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), headers);
        }
        return responseHeaders;
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) throws ApiException {
        Entity entity;
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = Entity.entity((Object)obj, (String)contentType);
        }
        return entity;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            RFC3339DateFormat dateFormat = new RFC3339DateFormat();
            return ((DateFormat)((Object)dateFormat)).format((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        return (T)response.readEntity(returnType);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserInfo {
        @JsonProperty(value="sub")
        private String sub = null;
        @JsonProperty(value="email")
        private String email = null;
        @JsonProperty(value="accounts")
        private List<Account> accounts = new ArrayList<Account>();
        @JsonProperty(value="name")
        private String name = null;
        @JsonProperty(value="given_name")
        private String givenName = null;
        @JsonProperty(value="family_name")
        private String familyName = null;
        @JsonProperty(value="created")
        private String created = null;

        public UserInfo sub(String sub) {
            this.sub = sub;
            return this;
        }

        @Schema(example="null", description="")
        public String getSub() {
            return this.sub;
        }

        public void setSub(String sub) {
            this.sub = sub;
        }

        public UserInfo email(String email) {
            this.email = email;
            return this;
        }

        @Schema(example="null", description="")
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public UserInfo accounts(List<Account> accounts) {
            this.accounts = accounts;
            return this;
        }

        public UserInfo addAccountsItem(Account accountsItem) {
            this.accounts.add(accountsItem);
            return this;
        }

        @Schema(example="null", description="")
        public List<Account> getAccounts() {
            return this.accounts;
        }

        public void setAccounts(List<Account> accounts) {
            this.accounts = accounts;
        }

        public UserInfo name(String name) {
            this.name = name;
            return this;
        }

        @Schema(example="null", description="")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UserInfo givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        @Schema(example="null", description="")
        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public UserInfo familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        @Schema(example="null", description="")
        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public UserInfo created(String created) {
            this.created = created;
            return this;
        }

        @Schema(example="null", description="")
        public String getCreated() {
            return this.created;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserInfo userInfo = (UserInfo)o;
            return Objects.equals(this.sub, userInfo.sub) && Objects.equals(this.email, userInfo.email) && Objects.equals(this.accounts, userInfo.accounts) && Objects.equals(this.name, userInfo.name) && Objects.equals(this.givenName, userInfo.givenName) && Objects.equals(this.familyName, userInfo.familyName) && Objects.equals(this.created, userInfo.created);
        }

        public int hashCode() {
            return Objects.hash(this.sub, this.email, this.accounts, this.name, this.givenName, this.familyName, this.created);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class UserInfo {\n");
            sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
            sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
            sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
            sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
            sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
            sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Account {
        @JsonProperty(value="account_id")
        private String accountId = null;
        @JsonProperty(value="is_default")
        private String isDefault = null;
        @JsonProperty(value="account_name")
        private String accountName = null;
        @JsonProperty(value="base_uri")
        private String baseUri = null;
        @JsonProperty(value="organization")
        private Organization organization = new Organization();

        public Account accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Schema(example="null", description="")
        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Account isDefault(String isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Schema(example="null", description="")
        public String getIsDefault() {
            return this.isDefault;
        }

        public void setIsDefault(String isDefault) {
            this.isDefault = isDefault;
        }

        public Account accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Schema(example="null", description="")
        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public Account baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @Schema(example="null", description="")
        public String getBaseUri() {
            return this.baseUri;
        }

        public void setBaseUri(String baseUri) {
            this.baseUri = baseUri;
        }

        public Account organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        @Schema(example="null", description="")
        public Organization getOrganization() {
            return this.organization;
        }

        public void setOrganization(Organization organization) {
            this.organization = organization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.accountId, account.accountId) && Objects.equals(this.isDefault, account.isDefault) && Objects.equals(this.accountName, account.accountName) && Objects.equals(this.baseUri, account.baseUri) && Objects.equals(this.organization, account.organization);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.isDefault, this.accountName, this.baseUri, this.organization);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Account {\n");
            sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
            sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
            sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
            sb.append("    baseUri: ").append(this.toIndentedString(this.baseUri)).append("\n");
            sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Organization {
        @JsonProperty(value="organization_id")
        private String organizationId = null;
        @JsonProperty(value="links")
        private List<Link> links = new ArrayList<Link>();

        public Organization organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Schema(example="null", description="")
        public String getOrganizationId() {
            return this.organizationId;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public Organization links(List<Link> links) {
            this.links = links;
            return this;
        }

        public Organization addLinksItem(Link linksItem) {
            this.links.add(linksItem);
            return this;
        }

        @Schema(example="null", description="")
        public List<Link> getLinks() {
            return this.links;
        }

        public void setLinks(List<Link> links) {
            this.links = links;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Organization organization = (Organization)o;
            return Objects.equals(this.organizationId, organization.organizationId) && Objects.equals(this.links, organization.links);
        }

        public int hashCode() {
            return Objects.hash(this.organizationId, this.links);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Organization {\n");
            sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
            sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Link {
        @JsonProperty(value="rel")
        private String rel = null;
        @JsonProperty(value="href")
        private String href = null;

        public Link rel(String rel) {
            this.rel = rel;
            return this;
        }

        @Schema(example="null", description="")
        public String getRel() {
            return this.rel;
        }

        public void setRel(String rel) {
            this.rel = rel;
        }

        public Link href(String href) {
            this.href = href;
            return this;
        }

        @Schema(example="null", description="")
        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            return Objects.equals(this.rel, link.rel) && Objects.equals(this.href, link.href);
        }

        public int hashCode() {
            return Objects.hash(this.rel, this.href);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Link {\n");
            sb.append("    rel: ").append(this.toIndentedString(this.rel)).append("\n");
            sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OAuthToken {
        @JsonProperty(value="access_token")
        private String accessToken = null;
        @JsonProperty(value="token_type")
        private String tokenType = null;
        @JsonProperty(value="refresh_token")
        private String refreshToken = null;
        @JsonProperty(value="expires_in")
        private Long expiresIn = 0L;
        @JsonProperty(value="scope")
        private String scope = null;

        public OAuthToken accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Schema(example="null", description="")
        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public OAuthToken isTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Schema(example="null", description="")
        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public OAuthToken refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Schema(example="null", description="")
        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public OAuthToken expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Schema(example="3600L", description="0L")
        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Schema(example="null", description="")
        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuthToken oAuthToken = (OAuthToken)o;
            return Objects.equals(this.accessToken, oAuthToken.accessToken) && Objects.equals(this.tokenType, oAuthToken.tokenType) && Objects.equals(this.refreshToken, oAuthToken.refreshToken) && Objects.equals(this.expiresIn, oAuthToken.expiresIn);
        }

        public int hashCode() {
            return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class OAuthToken {\n");
            sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
            sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
            sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
            sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }
}

