/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Control the overall clickwrap container and inherited styles such as font.")
public class ContainerStyles {
    @JsonProperty(value="backgroundColor")
    private String backgroundColor = null;
    @JsonProperty(value="borderColor")
    private String borderColor = null;
    @JsonProperty(value="borderRadius")
    private String borderRadius = null;
    @JsonProperty(value="borderStyle")
    private String borderStyle = null;
    @JsonProperty(value="borderWidth")
    private String borderWidth = null;

    public ContainerStyles backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Schema(description="This will be restricted to values not equal to: 'transparent', 'none'")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ContainerStyles borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @Schema(description="Adjust the border color of the clickwrap surrouding container.")
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public ContainerStyles borderRadius(String borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    @Schema(description="Adjust the border radius of the clickwrap surrouding container.")
    public String getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(String borderRadius) {
        this.borderRadius = borderRadius;
    }

    public ContainerStyles borderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
        return this;
    }

    @Schema(description="Adjust the border style of the clickwrap surrouding container.")
    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public ContainerStyles borderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @Schema(description="Adjust the border width of the clickwrap surrouding container.")
    public String getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStyles containerStyles = (ContainerStyles)o;
        return Objects.equals(this.backgroundColor, containerStyles.backgroundColor) && Objects.equals(this.borderColor, containerStyles.borderColor) && Objects.equals(this.borderRadius, containerStyles.borderRadius) && Objects.equals(this.borderStyle, containerStyles.borderStyle) && Objects.equals(this.borderWidth, containerStyles.borderWidth);
    }

    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.borderColor, this.borderRadius, this.borderStyle, this.borderWidth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerStyles {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    borderColor: ").append(this.toIndentedString(this.borderColor)).append("\n");
        sb.append("    borderRadius: ").append(this.toIndentedString(this.borderRadius)).append("\n");
        sb.append("    borderStyle: ").append(this.toIndentedString(this.borderStyle)).append("\n");
        sb.append("    borderWidth: ").append(this.toIndentedString(this.borderWidth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

