/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Control the display of the header.")
public class HeaderStyles {
    @JsonProperty(value="color")
    private String color = null;
    @JsonProperty(value="display")
    private DisplayEnum display = null;
    @JsonProperty(value="fontFamily")
    private String fontFamily = null;
    @JsonProperty(value="fontSize")
    private String fontSize = null;
    @JsonProperty(value="fontStyle")
    private String fontStyle = null;
    @JsonProperty(value="fontWeight")
    private Object fontWeight = null;
    @JsonProperty(value="textDecoration")
    private String textDecoration = null;

    public HeaderStyles color(String color) {
        this.color = color;
        return this;
    }

    @Schema(description="Control the fore-ground color of the element.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public HeaderStyles display(DisplayEnum display) {
        this.display = display;
        return this;
    }

    @Schema(description="Control the display of the header. Can only be set to 'none' over the default for hiding purposes.")
    public DisplayEnum getDisplay() {
        return this.display;
    }

    public void setDisplay(DisplayEnum display) {
        this.display = display;
    }

    public HeaderStyles fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @Schema(description="Control the font family of the text.")
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public HeaderStyles fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Schema(description="Control the font size of the text.")
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public HeaderStyles fontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    @Schema(description="Control the font style of the text.")
    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public HeaderStyles fontWeight(Object fontWeight) {
        this.fontWeight = fontWeight;
        return this;
    }

    @Schema(description="Control the font weight of the text.")
    public Object getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(Object fontWeight) {
        this.fontWeight = fontWeight;
    }

    public HeaderStyles textDecoration(String textDecoration) {
        this.textDecoration = textDecoration;
        return this;
    }

    @Schema(description="Control the underline and other styles of the text.")
    public String getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(String textDecoration) {
        this.textDecoration = textDecoration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderStyles headerStyles = (HeaderStyles)o;
        return Objects.equals(this.color, headerStyles.color) && Objects.equals((Object)this.display, (Object)headerStyles.display) && Objects.equals(this.fontFamily, headerStyles.fontFamily) && Objects.equals(this.fontSize, headerStyles.fontSize) && Objects.equals(this.fontStyle, headerStyles.fontStyle) && Objects.equals(this.fontWeight, headerStyles.fontWeight) && Objects.equals(this.textDecoration, headerStyles.textDecoration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.display, this.fontFamily, this.fontSize, this.fontStyle, this.fontWeight, this.textDecoration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeaderStyles {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    display: ").append(this.toIndentedString((Object)this.display)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    fontStyle: ").append(this.toIndentedString(this.fontStyle)).append("\n");
        sb.append("    fontWeight: ").append(this.toIndentedString(this.fontWeight)).append("\n");
        sb.append("    textDecoration: ").append(this.toIndentedString(this.textDecoration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisplayEnum {
        NONE("none");

        private String value;

        private DisplayEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayEnum fromValue(String value) {
            for (DisplayEnum b : DisplayEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

