/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Contains details about a specific cloud storage provider.")
public class CloudStorageProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="authenticationUrl")
    private String authenticationUrl = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="redirectUrl")
    private String redirectUrl = null;
    @JsonProperty(value="service")
    private String service = null;
    @JsonProperty(value="serviceId")
    private String serviceId = null;

    public CloudStorageProvider authenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
        return this;
    }

    @Schema(description="The authentication URL used for the cloud storage provider. This information is only included in the response if the user has not passed authentication for the cloud storage provider. If the redirectUrl query string is provided, the returnUrl is appended to the authenticationUrl. ")
    public String getAuthenticationUrl() {
        return this.authenticationUrl;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    public CloudStorageProvider errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public CloudStorageProvider redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Schema(description="The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.  The redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public CloudStorageProvider service(String service) {
        this.service = service;
        return this;
    }

    @Schema(description="The service name for the cloud storage provider.")
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public CloudStorageProvider serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Schema(description="The DocuSign generated ID for the cloud storage provider")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudStorageProvider cloudStorageProvider = (CloudStorageProvider)o;
        return Objects.equals(this.authenticationUrl, cloudStorageProvider.authenticationUrl) && Objects.equals(this.errorDetails, cloudStorageProvider.errorDetails) && Objects.equals(this.redirectUrl, cloudStorageProvider.redirectUrl) && Objects.equals(this.service, cloudStorageProvider.service) && Objects.equals(this.serviceId, cloudStorageProvider.serviceId);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationUrl, this.errorDetails, this.redirectUrl, this.service, this.serviceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudStorageProvider {\n");
        sb.append("    authenticationUrl: ").append(this.toIndentedString(this.authenticationUrl)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

