/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.EnvelopeTransactionStatus;
import com.docusign.esign.model.Folder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Result set for the Envelopes: listStatusChanges method")
public class EnvelopesInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="continuationToken")
    private String continuationToken = null;
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="envelopes")
    private List<Envelope> envelopes = null;
    @JsonProperty(value="envelopeSearchSource")
    private String envelopeSearchSource = null;
    @JsonProperty(value="envelopeTransactionStatuses")
    private List<EnvelopeTransactionStatus> envelopeTransactionStatuses = null;
    @JsonProperty(value="folders")
    private List<Folder> folders = null;
    @JsonProperty(value="lastQueriedDateTime")
    private String lastQueriedDateTime = null;
    @JsonProperty(value="nextUri")
    private String nextUri = null;
    @JsonProperty(value="previousUri")
    private String previousUri = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalSetSize")
    private String totalSetSize = null;

    public EnvelopesInformation continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Schema(description="")
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public EnvelopesInformation endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Schema(description="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public EnvelopesInformation envelopes(List<Envelope> envelopes) {
        this.envelopes = envelopes;
        return this;
    }

    public EnvelopesInformation addEnvelopesItem(Envelope envelopesItem) {
        if (this.envelopes == null) {
            this.envelopes = new ArrayList<Envelope>();
        }
        this.envelopes.add(envelopesItem);
        return this;
    }

    @Schema(description="")
    public List<Envelope> getEnvelopes() {
        return this.envelopes;
    }

    public void setEnvelopes(List<Envelope> envelopes) {
        this.envelopes = envelopes;
    }

    public EnvelopesInformation envelopeSearchSource(String envelopeSearchSource) {
        this.envelopeSearchSource = envelopeSearchSource;
        return this;
    }

    @Schema(description="")
    public String getEnvelopeSearchSource() {
        return this.envelopeSearchSource;
    }

    public void setEnvelopeSearchSource(String envelopeSearchSource) {
        this.envelopeSearchSource = envelopeSearchSource;
    }

    public EnvelopesInformation envelopeTransactionStatuses(List<EnvelopeTransactionStatus> envelopeTransactionStatuses) {
        this.envelopeTransactionStatuses = envelopeTransactionStatuses;
        return this;
    }

    public EnvelopesInformation addEnvelopeTransactionStatusesItem(EnvelopeTransactionStatus envelopeTransactionStatusesItem) {
        if (this.envelopeTransactionStatuses == null) {
            this.envelopeTransactionStatuses = new ArrayList<EnvelopeTransactionStatus>();
        }
        this.envelopeTransactionStatuses.add(envelopeTransactionStatusesItem);
        return this;
    }

    @Schema(description="")
    public List<EnvelopeTransactionStatus> getEnvelopeTransactionStatuses() {
        return this.envelopeTransactionStatuses;
    }

    public void setEnvelopeTransactionStatuses(List<EnvelopeTransactionStatus> envelopeTransactionStatuses) {
        this.envelopeTransactionStatuses = envelopeTransactionStatuses;
    }

    public EnvelopesInformation folders(List<Folder> folders) {
        this.folders = folders;
        return this;
    }

    public EnvelopesInformation addFoldersItem(Folder foldersItem) {
        if (this.folders == null) {
            this.folders = new ArrayList<Folder>();
        }
        this.folders.add(foldersItem);
        return this;
    }

    @Schema(description="")
    public List<Folder> getFolders() {
        return this.folders;
    }

    public void setFolders(List<Folder> folders) {
        this.folders = folders;
    }

    public EnvelopesInformation lastQueriedDateTime(String lastQueriedDateTime) {
        this.lastQueriedDateTime = lastQueriedDateTime;
        return this;
    }

    @Schema(description="")
    public String getLastQueriedDateTime() {
        return this.lastQueriedDateTime;
    }

    public void setLastQueriedDateTime(String lastQueriedDateTime) {
        this.lastQueriedDateTime = lastQueriedDateTime;
    }

    public EnvelopesInformation nextUri(String nextUri) {
        this.nextUri = nextUri;
        return this;
    }

    @Schema(description="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null. ")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    public EnvelopesInformation previousUri(String previousUri) {
        this.previousUri = previousUri;
        return this;
    }

    @Schema(description="The postal code for the billing address.")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    public EnvelopesInformation resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @Schema(description="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public EnvelopesInformation startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Schema(description="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public EnvelopesInformation totalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @Schema(description="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvelopesInformation envelopesInformation = (EnvelopesInformation)o;
        return Objects.equals(this.continuationToken, envelopesInformation.continuationToken) && Objects.equals(this.endPosition, envelopesInformation.endPosition) && Objects.equals(this.envelopes, envelopesInformation.envelopes) && Objects.equals(this.envelopeSearchSource, envelopesInformation.envelopeSearchSource) && Objects.equals(this.envelopeTransactionStatuses, envelopesInformation.envelopeTransactionStatuses) && Objects.equals(this.folders, envelopesInformation.folders) && Objects.equals(this.lastQueriedDateTime, envelopesInformation.lastQueriedDateTime) && Objects.equals(this.nextUri, envelopesInformation.nextUri) && Objects.equals(this.previousUri, envelopesInformation.previousUri) && Objects.equals(this.resultSetSize, envelopesInformation.resultSetSize) && Objects.equals(this.startPosition, envelopesInformation.startPosition) && Objects.equals(this.totalSetSize, envelopesInformation.totalSetSize);
    }

    public int hashCode() {
        return Objects.hash(this.continuationToken, this.endPosition, this.envelopes, this.envelopeSearchSource, this.envelopeTransactionStatuses, this.folders, this.lastQueriedDateTime, this.nextUri, this.previousUri, this.resultSetSize, this.startPosition, this.totalSetSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvelopesInformation {\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    envelopes: ").append(this.toIndentedString(this.envelopes)).append("\n");
        sb.append("    envelopeSearchSource: ").append(this.toIndentedString(this.envelopeSearchSource)).append("\n");
        sb.append("    envelopeTransactionStatuses: ").append(this.toIndentedString(this.envelopeTransactionStatuses)).append("\n");
        sb.append("    folders: ").append(this.toIndentedString(this.folders)).append("\n");
        sb.append("    lastQueriedDateTime: ").append(this.toIndentedString(this.lastQueriedDateTime)).append("\n");
        sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

