/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.RecipientTokenClientURLs;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The request body for the [EnvelopeViews: createRecipient](/docs/esign-rest-api/reference/envelopes/envelopeviews/createrecipient/) and [EnvelopeViews: createSharedRecipient](/docs/esign-rest-api/reference/envelopes/envelopeviews/createsharedrecipient/) methods.")
public class RecipientViewRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="assertionId")
    private String assertionId = null;
    @JsonProperty(value="authenticationInstant")
    private String authenticationInstant = null;
    @JsonProperty(value="authenticationMethod")
    private String authenticationMethod = null;
    @JsonProperty(value="clientURLs")
    private RecipientTokenClientURLs clientURLs = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="displayFormat")
    private String displayFormat = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="frameAncestors")
    private List<String> frameAncestors = null;
    @JsonProperty(value="messageOrigins")
    private List<String> messageOrigins = null;
    @JsonProperty(value="pingFrequency")
    private String pingFrequency = null;
    @JsonProperty(value="pingUrl")
    private String pingUrl = null;
    @JsonProperty(value="recipientId")
    private String recipientId = null;
    @JsonProperty(value="returnUrl")
    private String returnUrl = null;
    @JsonProperty(value="securityDomain")
    private String securityDomain = null;
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="xFrameOptions")
    private String xFrameOptions = null;
    @JsonProperty(value="xFrameOptionsAllowFromUrl")
    private String xFrameOptionsAllowFromUrl = null;

    public RecipientViewRequest assertionId(String assertionId) {
        this.assertionId = assertionId;
        return this;
    }

    @Schema(description="A unique identifier of the authentication event executed by the client application.")
    public String getAssertionId() {
        return this.assertionId;
    }

    public void setAssertionId(String assertionId) {
        this.assertionId = assertionId;
    }

    public RecipientViewRequest authenticationInstant(String authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
        return this;
    }

    @Schema(description="A sender generated value that indicates the date/time that the signer was authenticated.")
    public String getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(String authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
    }

    public RecipientViewRequest authenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @Schema(description="A sender created value that indicates the convention used to authenticate the signer. This information is included in the Certificate of Completion.")
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public RecipientViewRequest clientURLs(RecipientTokenClientURLs clientURLs) {
        this.clientURLs = clientURLs;
        return this;
    }

    @Schema(description="")
    public RecipientTokenClientURLs getClientURLs() {
        return this.clientURLs;
    }

    public void setClientURLs(RecipientTokenClientURLs clientURLs) {
        this.clientURLs = clientURLs;
    }

    public RecipientViewRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="A sender created value that shows the recipient is embedded (captive).   Maximum length: 100 characters.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public RecipientViewRequest displayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
        return this;
    }

    @Schema(description="")
    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    public RecipientViewRequest email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Specifies the email of the recipient. You can use either email and userName or userId to identify the recipient.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public RecipientViewRequest frameAncestors(List<String> frameAncestors) {
        this.frameAncestors = frameAncestors;
        return this;
    }

    public RecipientViewRequest addFrameAncestorsItem(String frameAncestorsItem) {
        if (this.frameAncestors == null) {
            this.frameAncestors = new ArrayList<String>();
        }
        this.frameAncestors.add(frameAncestorsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getFrameAncestors() {
        return this.frameAncestors;
    }

    public void setFrameAncestors(List<String> frameAncestors) {
        this.frameAncestors = frameAncestors;
    }

    public RecipientViewRequest messageOrigins(List<String> messageOrigins) {
        this.messageOrigins = messageOrigins;
        return this;
    }

    public RecipientViewRequest addMessageOriginsItem(String messageOriginsItem) {
        if (this.messageOrigins == null) {
            this.messageOrigins = new ArrayList<String>();
        }
        this.messageOrigins.add(messageOriginsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getMessageOrigins() {
        return this.messageOrigins;
    }

    public void setMessageOrigins(List<String> messageOrigins) {
        this.messageOrigins = messageOrigins;
    }

    public RecipientViewRequest pingFrequency(String pingFrequency) {
        this.pingFrequency = pingFrequency;
        return this;
    }

    @Schema(description="Only used if pingUrl is specified. This is the interval, in seconds, between pings on the pingUrl.  The default is 300 seconds. Valid values are 60-1200 seconds.")
    public String getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(String pingFrequency) {
        this.pingFrequency = pingFrequency;
    }

    public RecipientViewRequest pingUrl(String pingUrl) {
        this.pingUrl = pingUrl;
        return this;
    }

    @Schema(description="A client Url to be pinged by the DocuSign Signing experience to indicate to the client that Signing is active. An HTTP Get is executed against the client. The response from the client is ignored. The intent is for the client to reset it's session timer when the request is received.")
    public String getPingUrl() {
        return this.pingUrl;
    }

    public void setPingUrl(String pingUrl) {
        this.pingUrl = pingUrl;
    }

    public RecipientViewRequest recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @Schema(description="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public RecipientViewRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="The url the recipient is redirected to after the signing session has ended. DocuSign redirects to the url and includes an event parameter that can be used by your application. Possible event parameter values:   * cancel (recipient canceled the signing operation) * decline (recipient declined to sign) * exception (an exception occurred) * fax_pending (recipient has a fax pending) * session_timeout (session timed out) * signing_complete (signer completed the signing ceremony) * ttl_expired (the TTL, time to live, timer expired) * viewing_complete (recipient completed viewing the envelope)  ###### Note: Include https:// in the URL or the redirect might not succeed on some browsers. ")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public RecipientViewRequest securityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    @Schema(description="The domain in which the user authenticated.")
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public RecipientViewRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="Specifies the user ID of the recipient. You can use with user ID or email and user name to identify the recipient. If user ID is used and a client user ID is provided, the value in the `userId` property must match a recipient ID (which can be retrieved with a GET recipients call) for the envelope. If a user ID is used and a clientUser ID is not provided, the user ID match the user ID of the authenticating user.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public RecipientViewRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="Specifies the username of the recipient. You can use either email and userName or userId to identify the recipient.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public RecipientViewRequest xFrameOptions(String xFrameOptions) {
        this.xFrameOptions = xFrameOptions;
        return this;
    }

    @Schema(description="")
    public String getXFrameOptions() {
        return this.xFrameOptions;
    }

    public void setXFrameOptions(String xFrameOptions) {
        this.xFrameOptions = xFrameOptions;
    }

    public RecipientViewRequest xFrameOptionsAllowFromUrl(String xFrameOptionsAllowFromUrl) {
        this.xFrameOptionsAllowFromUrl = xFrameOptionsAllowFromUrl;
        return this;
    }

    @Schema(description="")
    public String getXFrameOptionsAllowFromUrl() {
        return this.xFrameOptionsAllowFromUrl;
    }

    public void setXFrameOptionsAllowFromUrl(String xFrameOptionsAllowFromUrl) {
        this.xFrameOptionsAllowFromUrl = xFrameOptionsAllowFromUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientViewRequest recipientViewRequest = (RecipientViewRequest)o;
        return Objects.equals(this.assertionId, recipientViewRequest.assertionId) && Objects.equals(this.authenticationInstant, recipientViewRequest.authenticationInstant) && Objects.equals(this.authenticationMethod, recipientViewRequest.authenticationMethod) && Objects.equals(this.clientURLs, recipientViewRequest.clientURLs) && Objects.equals(this.clientUserId, recipientViewRequest.clientUserId) && Objects.equals(this.displayFormat, recipientViewRequest.displayFormat) && Objects.equals(this.email, recipientViewRequest.email) && Objects.equals(this.frameAncestors, recipientViewRequest.frameAncestors) && Objects.equals(this.messageOrigins, recipientViewRequest.messageOrigins) && Objects.equals(this.pingFrequency, recipientViewRequest.pingFrequency) && Objects.equals(this.pingUrl, recipientViewRequest.pingUrl) && Objects.equals(this.recipientId, recipientViewRequest.recipientId) && Objects.equals(this.returnUrl, recipientViewRequest.returnUrl) && Objects.equals(this.securityDomain, recipientViewRequest.securityDomain) && Objects.equals(this.userId, recipientViewRequest.userId) && Objects.equals(this.userName, recipientViewRequest.userName) && Objects.equals(this.xFrameOptions, recipientViewRequest.xFrameOptions) && Objects.equals(this.xFrameOptionsAllowFromUrl, recipientViewRequest.xFrameOptionsAllowFromUrl);
    }

    public int hashCode() {
        return Objects.hash(this.assertionId, this.authenticationInstant, this.authenticationMethod, this.clientURLs, this.clientUserId, this.displayFormat, this.email, this.frameAncestors, this.messageOrigins, this.pingFrequency, this.pingUrl, this.recipientId, this.returnUrl, this.securityDomain, this.userId, this.userName, this.xFrameOptions, this.xFrameOptionsAllowFromUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientViewRequest {\n");
        sb.append("    assertionId: ").append(this.toIndentedString(this.assertionId)).append("\n");
        sb.append("    authenticationInstant: ").append(this.toIndentedString(this.authenticationInstant)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString(this.authenticationMethod)).append("\n");
        sb.append("    clientURLs: ").append(this.toIndentedString(this.clientURLs)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    displayFormat: ").append(this.toIndentedString(this.displayFormat)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    frameAncestors: ").append(this.toIndentedString(this.frameAncestors)).append("\n");
        sb.append("    messageOrigins: ").append(this.toIndentedString(this.messageOrigins)).append("\n");
        sb.append("    pingFrequency: ").append(this.toIndentedString(this.pingFrequency)).append("\n");
        sb.append("    pingUrl: ").append(this.toIndentedString(this.pingUrl)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    securityDomain: ").append(this.toIndentedString(this.securityDomain)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    xFrameOptions: ").append(this.toIndentedString(this.xFrameOptions)).append("\n");
        sb.append("    xFrameOptionsAllowFromUrl: ").append(this.toIndentedString(this.xFrameOptionsAllowFromUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

