/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A complex element that specifies reminder settings for the envelope")
public class Reminders
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="reminderDelay")
    private String reminderDelay = null;
    @JsonProperty(value="reminderEnabled")
    private String reminderEnabled = null;
    @JsonProperty(value="reminderFrequency")
    private String reminderFrequency = null;

    public Reminders reminderDelay(String reminderDelay) {
        this.reminderDelay = reminderDelay;
        return this;
    }

    @Schema(description="An interger that sets the number of days after the recipient receives the envelope that reminder emails are sent to the recipient.")
    public String getReminderDelay() {
        return this.reminderDelay;
    }

    public void setReminderDelay(String reminderDelay) {
        this.reminderDelay = reminderDelay;
    }

    public Reminders reminderEnabled(String reminderEnabled) {
        this.reminderEnabled = reminderEnabled;
        return this;
    }

    @Schema(description="When set to **true**, the envelope expires (is no longer available for signing) in the set number of days. If false, the account default setting is used. If the account does not have an expiration setting, the DocuSign default value of 120 days is used.")
    public String getReminderEnabled() {
        return this.reminderEnabled;
    }

    public void setReminderEnabled(String reminderEnabled) {
        this.reminderEnabled = reminderEnabled;
    }

    public Reminders reminderFrequency(String reminderFrequency) {
        this.reminderFrequency = reminderFrequency;
        return this;
    }

    @Schema(description="An interger that sets the interval, in days, between reminder emails.")
    public String getReminderFrequency() {
        return this.reminderFrequency;
    }

    public void setReminderFrequency(String reminderFrequency) {
        this.reminderFrequency = reminderFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reminders reminders = (Reminders)o;
        return Objects.equals(this.reminderDelay, reminders.reminderDelay) && Objects.equals(this.reminderEnabled, reminders.reminderEnabled) && Objects.equals(this.reminderFrequency, reminders.reminderFrequency);
    }

    public int hashCode() {
        return Objects.hash(this.reminderDelay, this.reminderEnabled, this.reminderFrequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reminders {\n");
        sb.append("    reminderDelay: ").append(this.toIndentedString(this.reminderDelay)).append("\n");
        sb.append("    reminderEnabled: ").append(this.toIndentedString(this.reminderEnabled)).append("\n");
        sb.append("    reminderFrequency: ").append(this.toIndentedString(this.reminderFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

