/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FormLibrarySummaryList;
import com.docusign.rooms.model.FormSummaryList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class FormLibrariesApi {
    private ApiClient apiClient;

    public FormLibrariesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormLibrariesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FormLibrarySummaryList getFormLibraries(String accountId) throws ApiException {
        return this.getFormLibraries(accountId, null);
    }

    public FormLibrarySummaryList getFormLibraries(String accountId, GetFormLibrariesOptions options) throws ApiException {
        ApiResponse<FormLibrarySummaryList> localVarResponse = this.getFormLibrariesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FormLibrarySummaryList> getFormLibrariesWithHttpInfo(String accountId, GetFormLibrariesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormLibraries");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_libraries".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormLibrarySummaryList> localVarReturnType = new GenericType<FormLibrarySummaryList>(){};
        FormLibrarySummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormLibrarySummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public FormSummaryList getFormLibraryForms(String accountId, UUID formLibraryId) throws ApiException {
        return this.getFormLibraryForms(accountId, formLibraryId, null);
    }

    public FormSummaryList getFormLibraryForms(String accountId, UUID formLibraryId, GetFormLibraryFormsOptions options) throws ApiException {
        ApiResponse<FormSummaryList> localVarResponse = this.getFormLibraryFormsWithHttpInfo(accountId, formLibraryId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FormSummaryList> getFormLibraryFormsWithHttpInfo(String accountId, UUID formLibraryId, GetFormLibraryFormsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormLibraryForms");
        }
        if (formLibraryId == null) {
            throw new ApiException(400, "Missing the required parameter 'formLibraryId' when calling getFormLibraryForms");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_libraries/{formLibraryId}/forms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formLibraryId\\}", this.apiClient.escapeString(formLibraryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormSummaryList> localVarReturnType = new GenericType<FormSummaryList>(){};
        FormSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetFormLibraryFormsOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetFormLibrariesOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }
}

