/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FormProviderAssociationsSummaryList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class FormProviderAssociationsApi {
    private ApiClient apiClient;

    public FormProviderAssociationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormProviderAssociationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FormProviderAssociationsSummaryList getFormProviderAssociations(String accountId, String providerId) throws ApiException {
        return this.getFormProviderAssociations(accountId, providerId, null);
    }

    public FormProviderAssociationsSummaryList getFormProviderAssociations(String accountId, String providerId, GetFormProviderAssociationsOptions options) throws ApiException {
        ApiResponse<FormProviderAssociationsSummaryList> localVarResponse = this.getFormProviderAssociationsWithHttpInfo(accountId, providerId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<FormProviderAssociationsSummaryList> getFormProviderAssociationsWithHttpInfo(String accountId, String providerId, GetFormProviderAssociationsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormProviderAssociations");
        }
        if (providerId == null) {
            throw new ApiException(400, "Missing the required parameter 'providerId' when calling getFormProviderAssociations");
        }
        String localVarPath = "/v2/accounts/{accountId}/form_providers/{providerId}/associations".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{providerId\\}", this.apiClient.escapeString(providerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormProviderAssociationsSummaryList> localVarReturnType = new GenericType<FormProviderAssociationsSummaryList>(){};
        FormProviderAssociationsSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormProviderAssociationsSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetFormProviderAssociationsOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }
}

