/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.Office;
import com.docusign.rooms.model.OfficeForCreate;
import com.docusign.rooms.model.OfficeReferenceCountList;
import com.docusign.rooms.model.OfficeSummaryList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class OfficesApi {
    private ApiClient apiClient;

    public OfficesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OfficesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Office createOffice(String accountId, OfficeForCreate body) throws ApiException {
        ApiResponse<Office> localVarResponse = this.createOfficeWithHttpInfo(accountId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<Office> createOfficeWithHttpInfo(String accountId, OfficeForCreate body) throws ApiException {
        OfficeForCreate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/offices".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json", "application/xml", "text/xml", "application/_*+xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Office> localVarReturnType = new GenericType<Office>(){};
        Office localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Office>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteOffice(String accountId, Integer officeId) throws ApiException {
        this.deleteOfficeWithHttpInfo(accountId, officeId);
    }

    public ApiResponse<Object> deleteOfficeWithHttpInfo(String accountId, Integer officeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteOffice");
        }
        if (officeId == null) {
            throw new ApiException(400, "Missing the required parameter 'officeId' when calling deleteOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/offices/{officeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{officeId\\}", this.apiClient.escapeString(officeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public Office getOffice(String accountId, Integer officeId) throws ApiException {
        ApiResponse<Office> localVarResponse = this.getOfficeWithHttpInfo(accountId, officeId);
        return localVarResponse.getData();
    }

    public ApiResponse<Office> getOfficeWithHttpInfo(String accountId, Integer officeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getOffice");
        }
        if (officeId == null) {
            throw new ApiException(400, "Missing the required parameter 'officeId' when calling getOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/offices/{officeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{officeId\\}", this.apiClient.escapeString(officeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Office> localVarReturnType = new GenericType<Office>(){};
        Office localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Office>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OfficeSummaryList getOffices(String accountId) throws ApiException {
        return this.getOffices(accountId, null);
    }

    public OfficeSummaryList getOffices(String accountId, GetOfficesOptions options) throws ApiException {
        ApiResponse<OfficeSummaryList> localVarResponse = this.getOfficesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<OfficeSummaryList> getOfficesWithHttpInfo(String accountId, GetOfficesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getOffices");
        }
        String localVarPath = "/v2/accounts/{accountId}/offices".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("onlyAccessible", options.onlyAccessible));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", options.search));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OfficeSummaryList> localVarReturnType = new GenericType<OfficeSummaryList>(){};
        OfficeSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OfficeSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OfficeReferenceCountList getReferenceCounts(String accountId, Integer officeId) throws ApiException {
        ApiResponse<OfficeReferenceCountList> localVarResponse = this.getReferenceCountsWithHttpInfo(accountId, officeId);
        return localVarResponse.getData();
    }

    public ApiResponse<OfficeReferenceCountList> getReferenceCountsWithHttpInfo(String accountId, Integer officeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getReferenceCounts");
        }
        if (officeId == null) {
            throw new ApiException(400, "Missing the required parameter 'officeId' when calling getReferenceCounts");
        }
        String localVarPath = "/v2/accounts/{accountId}/offices/{officeId}/reference_counts".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{officeId\\}", this.apiClient.escapeString(officeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OfficeReferenceCountList> localVarReturnType = new GenericType<OfficeReferenceCountList>(){};
        OfficeReferenceCountList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OfficeReferenceCountList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetOfficesOptions {
        private Integer count = null;
        private Integer startPosition = null;
        private Boolean onlyAccessible = null;
        private String search = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setOnlyAccessible(Boolean onlyAccessible) {
            this.onlyAccessible = onlyAccessible;
        }

        public Boolean getOnlyAccessible() {
            return this.onlyAccessible;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }
    }
}

