/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mimepull;

final class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b, int start, int end, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i2 = start;
        if (end > start) {
            int digit;
            int limit;
            if (b[i2] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i2;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i2 < end) {
                if ((digit = Character.digit((char)b[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start, end));
                }
                result = -digit;
            }
            while (i2 < end) {
                if ((digit = Character.digit((char)b[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("illegal number");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i2 > start + 1) {
                return result;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result;
    }

    public static String toString(byte[] b, int start, int end) {
        int size = end - start;
        char[] theChars = new char[size];
        int i2 = 0;
        int j = start;
        while (i2 < size) {
            theChars[i2++] = (char)(b[j++] & 0xFF);
        }
        return new String(theChars);
    }
}

