/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FormDetails;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class FormDetailsApi {
    private ApiClient apiClient;

    public FormDetailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormDetailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FormDetails getFormDetails(String accountId, UUID formId) throws ApiException {
        ApiResponse<FormDetails> localVarResponse = this.getFormDetailsWithHttpInfo(accountId, formId);
        return localVarResponse.getData();
    }

    public ApiResponse<FormDetails> getFormDetailsWithHttpInfo(String accountId, UUID formId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormDetails");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getFormDetails");
        }
        String localVarPath = "/v2/accounts/{accountId}/forms/{formId}/details".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formId\\}", this.apiClient.escapeString(formId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json", "application/xml", "text/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FormDetails> localVarReturnType = new GenericType<FormDetails>(){};
        FormDetails localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<FormDetails>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }
}

