/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Information about a DocuSign template that will be used to seed a web form.")
public class TemplateProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="originalTemplateId")
    private String originalTemplateId = null;
    @JsonProperty(value="clonedTemplateId")
    private String clonedTemplateId = null;
    @JsonProperty(value="importedDateTime")
    private String importedDateTime = null;
    @JsonProperty(value="recipientIds")
    private List<String> recipientIds = null;

    public TemplateProperties originalTemplateId(String originalTemplateId) {
        this.originalTemplateId = originalTemplateId;
        return this;
    }

    @Schema(description="Template identifier for original Template that is used by the DocuSign Template API.")
    public String getOriginalTemplateId() {
        return this.originalTemplateId;
    }

    public void setOriginalTemplateId(String originalTemplateId) {
        this.originalTemplateId = originalTemplateId;
    }

    public TemplateProperties clonedTemplateId(String clonedTemplateId) {
        this.clonedTemplateId = clonedTemplateId;
        return this;
    }

    @Schema(description="Template identifier for cloned Template that is used by the DocuSign Template API.")
    public String getClonedTemplateId() {
        return this.clonedTemplateId;
    }

    public void setClonedTemplateId(String clonedTemplateId) {
        this.clonedTemplateId = clonedTemplateId;
    }

    public TemplateProperties importedDateTime(String importedDateTime) {
        this.importedDateTime = importedDateTime;
        return this;
    }

    @Schema(description="Track the time of assignment of Template information to the Form.")
    public String getImportedDateTime() {
        return this.importedDateTime;
    }

    public void setImportedDateTime(String importedDateTime) {
        this.importedDateTime = importedDateTime;
    }

    public TemplateProperties recipientIds(List<String> recipientIds) {
        this.recipientIds = recipientIds;
        return this;
    }

    public TemplateProperties addRecipientIdsItem(String recipientIdsItem) {
        if (this.recipientIds == null) {
            this.recipientIds = new ArrayList<String>();
        }
        this.recipientIds.add(recipientIdsItem);
        return this;
    }

    @Schema(description="Track mapped recipients on Template.")
    public List<String> getRecipientIds() {
        return this.recipientIds;
    }

    public void setRecipientIds(List<String> recipientIds) {
        this.recipientIds = recipientIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateProperties templateProperties = (TemplateProperties)o;
        return Objects.equals(this.originalTemplateId, templateProperties.originalTemplateId) && Objects.equals(this.clonedTemplateId, templateProperties.clonedTemplateId) && Objects.equals(this.importedDateTime, templateProperties.importedDateTime) && Objects.equals(this.recipientIds, templateProperties.recipientIds);
    }

    public int hashCode() {
        return Objects.hash(this.originalTemplateId, this.clonedTemplateId, this.importedDateTime, this.recipientIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateProperties {\n");
        sb.append("    originalTemplateId: ").append(this.toIndentedString(this.originalTemplateId)).append("\n");
        sb.append("    clonedTemplateId: ").append(this.toIndentedString(this.clonedTemplateId)).append("\n");
        sb.append("    importedDateTime: ").append(this.toIndentedString(this.importedDateTime)).append("\n");
        sb.append("    recipientIds: ").append(this.toIndentedString(this.recipientIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

