/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Organization;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class Account {
    @JsonProperty(value="account_id")
    private String accountId;
    @JsonProperty(value="is_default")
    private boolean isDefault;
    @JsonProperty(value="account_name")
    private String accountName;
    @JsonProperty(value="base_uri")
    private String baseUri;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="organization")
    private Optional<? extends Organization> organization;

    @JsonCreator
    public Account(@JsonProperty(value="account_id") String accountId, @JsonProperty(value="is_default") boolean isDefault, @JsonProperty(value="account_name") String accountName, @JsonProperty(value="base_uri") String baseUri, @JsonProperty(value="organization") Optional<? extends Organization> organization) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(isDefault, "isDefault");
        Utils.checkNotNull(accountName, "accountName");
        Utils.checkNotNull(baseUri, "baseUri");
        Utils.checkNotNull(organization, "organization");
        this.accountId = accountId;
        this.isDefault = isDefault;
        this.accountName = accountName;
        this.baseUri = baseUri;
        this.organization = organization;
    }

    public Account(String accountId, boolean isDefault, String accountName, String baseUri) {
        this(accountId, isDefault, accountName, baseUri, Optional.empty());
    }

    @JsonIgnore
    public String accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public boolean isDefault() {
        return this.isDefault;
    }

    @JsonIgnore
    public String accountName() {
        return this.accountName;
    }

    @JsonIgnore
    public String baseUri() {
        return this.baseUri;
    }

    @JsonIgnore
    public Optional<Organization> organization() {
        return this.organization;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Account withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public Account withIsDefault(boolean isDefault) {
        Utils.checkNotNull(isDefault, "isDefault");
        this.isDefault = isDefault;
        return this;
    }

    public Account withAccountName(String accountName) {
        Utils.checkNotNull(accountName, "accountName");
        this.accountName = accountName;
        return this;
    }

    public Account withBaseUri(String baseUri) {
        Utils.checkNotNull(baseUri, "baseUri");
        this.baseUri = baseUri;
        return this;
    }

    public Account withOrganization(Organization organization) {
        Utils.checkNotNull(organization, "organization");
        this.organization = Optional.ofNullable(organization);
        return this;
    }

    public Account withOrganization(Optional<? extends Organization> organization) {
        Utils.checkNotNull(organization, "organization");
        this.organization = organization;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account other = (Account)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.isDefault, other.isDefault) && Objects.deepEquals(this.accountName, other.accountName) && Objects.deepEquals(this.baseUri, other.baseUri) && Objects.deepEquals(this.organization, other.organization);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.isDefault, this.accountName, this.baseUri, this.organization);
    }

    public String toString() {
        return Utils.toString(Account.class, "accountId", this.accountId, "isDefault", this.isDefault, "accountName", this.accountName, "baseUri", this.baseUri, "organization", this.organization);
    }

    public static final class Builder {
        private String accountId;
        private Boolean isDefault;
        private String accountName;
        private String baseUri;
        private Optional<? extends Organization> organization = Optional.empty();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            Utils.checkNotNull(isDefault, "isDefault");
            this.isDefault = isDefault;
            return this;
        }

        public Builder accountName(String accountName) {
            Utils.checkNotNull(accountName, "accountName");
            this.accountName = accountName;
            return this;
        }

        public Builder baseUri(String baseUri) {
            Utils.checkNotNull(baseUri, "baseUri");
            this.baseUri = baseUri;
            return this;
        }

        public Builder organization(Organization organization) {
            Utils.checkNotNull(organization, "organization");
            this.organization = Optional.ofNullable(organization);
            return this;
        }

        public Builder organization(Optional<? extends Organization> organization) {
            Utils.checkNotNull(organization, "organization");
            this.organization = organization;
            return this;
        }

        public Account build() {
            return new Account(this.accountId, this.isDefault, this.accountName, this.baseUri, this.organization);
        }
    }
}

