/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import java.util.Arrays;
import java.util.List;

public enum AuthScope {
    ADM_STORE_UNIFIED_REPO_READ("adm_store_unified_repo_read"),
    ADM_STORE_UNIFIED_REPO_WRITE("adm_store_unified_repo_write"),
    AOW_MANAGE("aow_manage"),
    IMPERSONATION("impersonation"),
    MODELS_READ("models_read"),
    SIGNATURE("signature");

    private final String value;

    private AuthScope(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static List<AuthScope> getAllScopes() {
        return Arrays.asList(AuthScope.values());
    }

    public static List<AuthScope> getConnectedFieldsScopes() {
        return List.of(ADM_STORE_UNIFIED_REPO_READ, SIGNATURE);
    }

    public static List<AuthScope> getConnectedFieldsScopesForNavigator() {
        return List.of(ADM_STORE_UNIFIED_REPO_READ, ADM_STORE_UNIFIED_REPO_WRITE, SIGNATURE);
    }

    public static AuthScope fromValue(String value) {
        return Arrays.stream(AuthScope.values()).filter(scope -> scope.value.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown scope: " + value));
    }
}

