/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.ConfidentialAuthCodeGrantRequestBodyGrantType;
import com.docusign.iam.sdk.models.components.Flow;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class ConfidentialAuthCodeGrantRequestBody {
    @SpeakeasyMetadata(value="form:name=flow")
    private Optional<? extends Flow> flow;
    @SpeakeasyMetadata(value="form:name=grant_type")
    private Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType> grantType;
    @SpeakeasyMetadata(value="form:name=code")
    private String code;

    @JsonCreator
    public ConfidentialAuthCodeGrantRequestBody(Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType> grantType, String code) {
        Utils.checkNotNull(grantType, "grantType");
        Utils.checkNotNull(code, "code");
        this.flow = Builder._SINGLETON_VALUE_Flow.value();
        this.grantType = grantType;
        this.code = code;
    }

    public ConfidentialAuthCodeGrantRequestBody(String code) {
        this(Optional.empty(), code);
    }

    @JsonIgnore
    public Optional<Flow> flow() {
        return this.flow;
    }

    @JsonIgnore
    public Optional<ConfidentialAuthCodeGrantRequestBodyGrantType> grantType() {
        return this.grantType;
    }

    @JsonIgnore
    public String code() {
        return this.code;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ConfidentialAuthCodeGrantRequestBody withGrantType(ConfidentialAuthCodeGrantRequestBodyGrantType grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = Optional.ofNullable(grantType);
        return this;
    }

    public ConfidentialAuthCodeGrantRequestBody withGrantType(Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType> grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = grantType;
        return this;
    }

    public ConfidentialAuthCodeGrantRequestBody withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfidentialAuthCodeGrantRequestBody other = (ConfidentialAuthCodeGrantRequestBody)o;
        return Objects.deepEquals(this.flow, other.flow) && Objects.deepEquals(this.grantType, other.grantType) && Objects.deepEquals(this.code, other.code);
    }

    public int hashCode() {
        return Objects.hash(this.flow, this.grantType, this.code);
    }

    public String toString() {
        return Utils.toString(ConfidentialAuthCodeGrantRequestBody.class, "flow", this.flow, "grantType", this.grantType, "code", this.code);
    }

    public static final class Builder {
        private Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType> grantType;
        private String code;
        private static final LazySingletonValue<Optional<? extends Flow>> _SINGLETON_VALUE_Flow = new LazySingletonValue<Optional<? extends Flow>>("flow", "\"confidential\"", new TypeReference<Optional<? extends Flow>>(){});
        private static final LazySingletonValue<Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType>> _SINGLETON_VALUE_GrantType = new LazySingletonValue<Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType>>("grant_type", "\"authorization_code\"", new TypeReference<Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType>>(){});

        private Builder() {
        }

        public Builder grantType(ConfidentialAuthCodeGrantRequestBodyGrantType grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = Optional.ofNullable(grantType);
            return this;
        }

        public Builder grantType(Optional<? extends ConfidentialAuthCodeGrantRequestBodyGrantType> grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = grantType;
            return this;
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public ConfidentialAuthCodeGrantRequestBody build() {
            if (this.grantType == null) {
                this.grantType = _SINGLETON_VALUE_GrantType.value();
            }
            return new ConfidentialAuthCodeGrantRequestBody(this.grantType, this.code);
        }
    }
}

