/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Link {
    @JsonProperty(value="rel")
    private String rel;
    @JsonProperty(value="href")
    private String href;

    @JsonCreator
    public Link(@JsonProperty(value="rel") String rel, @JsonProperty(value="href") String href) {
        Utils.checkNotNull(rel, "rel");
        Utils.checkNotNull(href, "href");
        this.rel = rel;
        this.href = href;
    }

    @JsonIgnore
    public String rel() {
        return this.rel;
    }

    @JsonIgnore
    public String href() {
        return this.href;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Link withRel(String rel) {
        Utils.checkNotNull(rel, "rel");
        this.rel = rel;
        return this;
    }

    public Link withHref(String href) {
        Utils.checkNotNull(href, "href");
        this.href = href;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link other = (Link)o;
        return Objects.deepEquals(this.rel, other.rel) && Objects.deepEquals(this.href, other.href);
    }

    public int hashCode() {
        return Objects.hash(this.rel, this.href);
    }

    public String toString() {
        return Utils.toString(Link.class, "rel", this.rel, "href", this.href);
    }

    public static final class Builder {
        private String rel;
        private String href;

        private Builder() {
        }

        public Builder rel(String rel) {
            Utils.checkNotNull(rel, "rel");
            this.rel = rel;
            return this;
        }

        public Builder href(String href) {
            Utils.checkNotNull(href, "href");
            this.href = href;
            return this;
        }

        public Link build() {
            return new Link(this.rel, this.href);
        }
    }
}

