/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class Metadata {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="workflow_created_by")
    private Optional<String> workflowCreatedBy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="workflow_version")
    private Optional<String> workflowVersion;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="workflow_metadata_id")
    private Optional<String> workflowMetadataId;

    @JsonCreator
    public Metadata(@JsonProperty(value="workflow_created_by") Optional<String> workflowCreatedBy, @JsonProperty(value="workflow_version") Optional<String> workflowVersion, @JsonProperty(value="workflow_metadata_id") Optional<String> workflowMetadataId) {
        Utils.checkNotNull(workflowCreatedBy, "workflowCreatedBy");
        Utils.checkNotNull(workflowVersion, "workflowVersion");
        Utils.checkNotNull(workflowMetadataId, "workflowMetadataId");
        this.workflowCreatedBy = workflowCreatedBy;
        this.workflowVersion = workflowVersion;
        this.workflowMetadataId = workflowMetadataId;
    }

    public Metadata() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> workflowCreatedBy() {
        return this.workflowCreatedBy;
    }

    @JsonIgnore
    public Optional<String> workflowVersion() {
        return this.workflowVersion;
    }

    @JsonIgnore
    public Optional<String> workflowMetadataId() {
        return this.workflowMetadataId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Metadata withWorkflowCreatedBy(String workflowCreatedBy) {
        Utils.checkNotNull(workflowCreatedBy, "workflowCreatedBy");
        this.workflowCreatedBy = Optional.ofNullable(workflowCreatedBy);
        return this;
    }

    public Metadata withWorkflowCreatedBy(Optional<String> workflowCreatedBy) {
        Utils.checkNotNull(workflowCreatedBy, "workflowCreatedBy");
        this.workflowCreatedBy = workflowCreatedBy;
        return this;
    }

    public Metadata withWorkflowVersion(String workflowVersion) {
        Utils.checkNotNull(workflowVersion, "workflowVersion");
        this.workflowVersion = Optional.ofNullable(workflowVersion);
        return this;
    }

    public Metadata withWorkflowVersion(Optional<String> workflowVersion) {
        Utils.checkNotNull(workflowVersion, "workflowVersion");
        this.workflowVersion = workflowVersion;
        return this;
    }

    public Metadata withWorkflowMetadataId(String workflowMetadataId) {
        Utils.checkNotNull(workflowMetadataId, "workflowMetadataId");
        this.workflowMetadataId = Optional.ofNullable(workflowMetadataId);
        return this;
    }

    public Metadata withWorkflowMetadataId(Optional<String> workflowMetadataId) {
        Utils.checkNotNull(workflowMetadataId, "workflowMetadataId");
        this.workflowMetadataId = workflowMetadataId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata other = (Metadata)o;
        return Objects.deepEquals(this.workflowCreatedBy, other.workflowCreatedBy) && Objects.deepEquals(this.workflowVersion, other.workflowVersion) && Objects.deepEquals(this.workflowMetadataId, other.workflowMetadataId);
    }

    public int hashCode() {
        return Objects.hash(this.workflowCreatedBy, this.workflowVersion, this.workflowMetadataId);
    }

    public String toString() {
        return Utils.toString(Metadata.class, "workflowCreatedBy", this.workflowCreatedBy, "workflowVersion", this.workflowVersion, "workflowMetadataId", this.workflowMetadataId);
    }

    public static final class Builder {
        private Optional<String> workflowCreatedBy = Optional.empty();
        private Optional<String> workflowVersion = Optional.empty();
        private Optional<String> workflowMetadataId = Optional.empty();

        private Builder() {
        }

        public Builder workflowCreatedBy(String workflowCreatedBy) {
            Utils.checkNotNull(workflowCreatedBy, "workflowCreatedBy");
            this.workflowCreatedBy = Optional.ofNullable(workflowCreatedBy);
            return this;
        }

        public Builder workflowCreatedBy(Optional<String> workflowCreatedBy) {
            Utils.checkNotNull(workflowCreatedBy, "workflowCreatedBy");
            this.workflowCreatedBy = workflowCreatedBy;
            return this;
        }

        public Builder workflowVersion(String workflowVersion) {
            Utils.checkNotNull(workflowVersion, "workflowVersion");
            this.workflowVersion = Optional.ofNullable(workflowVersion);
            return this;
        }

        public Builder workflowVersion(Optional<String> workflowVersion) {
            Utils.checkNotNull(workflowVersion, "workflowVersion");
            this.workflowVersion = workflowVersion;
            return this;
        }

        public Builder workflowMetadataId(String workflowMetadataId) {
            Utils.checkNotNull(workflowMetadataId, "workflowMetadataId");
            this.workflowMetadataId = Optional.ofNullable(workflowMetadataId);
            return this;
        }

        public Builder workflowMetadataId(Optional<String> workflowMetadataId) {
            Utils.checkNotNull(workflowMetadataId, "workflowMetadataId");
            this.workflowMetadataId = workflowMetadataId;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.workflowCreatedBy, this.workflowVersion, this.workflowMetadataId);
        }
    }
}

