/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Tab;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class TabInfo {
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="tabs")
    private List<Tab> tabs;

    @JsonCreator
    public TabInfo(@JsonProperty(value="appId") String appId, @JsonProperty(value="tabs") List<Tab> tabs) {
        Utils.checkNotNull(appId, "appId");
        Utils.checkNotNull(tabs, "tabs");
        this.appId = appId;
        this.tabs = tabs;
    }

    @JsonIgnore
    public String appId() {
        return this.appId;
    }

    @JsonIgnore
    public List<Tab> tabs() {
        return this.tabs;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TabInfo withAppId(String appId) {
        Utils.checkNotNull(appId, "appId");
        this.appId = appId;
        return this;
    }

    public TabInfo withTabs(List<Tab> tabs) {
        Utils.checkNotNull(tabs, "tabs");
        this.tabs = tabs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabInfo other = (TabInfo)o;
        return Objects.deepEquals(this.appId, other.appId) && Objects.deepEquals(this.tabs, other.tabs);
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.tabs);
    }

    public String toString() {
        return Utils.toString(TabInfo.class, "appId", this.appId, "tabs", this.tabs);
    }

    public static final class Builder {
        private String appId;
        private List<Tab> tabs;

        private Builder() {
        }

        public Builder appId(String appId) {
            Utils.checkNotNull(appId, "appId");
            this.appId = appId;
            return this;
        }

        public Builder tabs(List<Tab> tabs) {
            Utils.checkNotNull(tabs, "tabs");
            this.tabs = tabs;
            return this;
        }

        public TabInfo build() {
            return new TabInfo(this.appId, this.tabs);
        }
    }
}

