/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.TriggerInputs;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class TriggerWorkflow {
    @JsonProperty(value="instance_name")
    private String instanceName;
    @JsonProperty(value="trigger_inputs")
    private Map<String, TriggerInputs> triggerInputs;

    @JsonCreator
    public TriggerWorkflow(@JsonProperty(value="instance_name") String instanceName, @JsonProperty(value="trigger_inputs") Map<String, TriggerInputs> triggerInputs) {
        Utils.checkNotNull(instanceName, "instanceName");
        triggerInputs = Utils.emptyMapIfNull(triggerInputs);
        this.instanceName = instanceName;
        this.triggerInputs = triggerInputs;
    }

    @JsonIgnore
    public String instanceName() {
        return this.instanceName;
    }

    @JsonIgnore
    public Map<String, TriggerInputs> triggerInputs() {
        return this.triggerInputs;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerWorkflow withInstanceName(String instanceName) {
        Utils.checkNotNull(instanceName, "instanceName");
        this.instanceName = instanceName;
        return this;
    }

    public TriggerWorkflow withTriggerInputs(Map<String, TriggerInputs> triggerInputs) {
        Utils.checkNotNull(triggerInputs, "triggerInputs");
        this.triggerInputs = triggerInputs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerWorkflow other = (TriggerWorkflow)o;
        return Objects.deepEquals(this.instanceName, other.instanceName) && Objects.deepEquals(this.triggerInputs, other.triggerInputs);
    }

    public int hashCode() {
        return Objects.hash(this.instanceName, this.triggerInputs);
    }

    public String toString() {
        return Utils.toString(TriggerWorkflow.class, "instanceName", this.instanceName, "triggerInputs", this.triggerInputs);
    }

    public static final class Builder {
        private String instanceName;
        private Map<String, TriggerInputs> triggerInputs;

        private Builder() {
        }

        public Builder instanceName(String instanceName) {
            Utils.checkNotNull(instanceName, "instanceName");
            this.instanceName = instanceName;
            return this;
        }

        public Builder triggerInputs(Map<String, TriggerInputs> triggerInputs) {
            Utils.checkNotNull(triggerInputs, "triggerInputs");
            this.triggerInputs = triggerInputs;
            return this;
        }

        public TriggerWorkflow build() {
            return new TriggerWorkflow(this.instanceName, this.triggerInputs);
        }
    }
}

