/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Account;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class UserInfo {
    @JsonProperty(value="sub")
    private String sub;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="given_name")
    private String givenName;
    @JsonProperty(value="family_name")
    private String familyName;
    @JsonProperty(value="created")
    private String created;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="accounts")
    private List<Account> accounts;

    @JsonCreator
    public UserInfo(@JsonProperty(value="sub") String sub, @JsonProperty(value="name") String name, @JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="created") String created, @JsonProperty(value="email") String email, @JsonProperty(value="accounts") List<Account> accounts) {
        Utils.checkNotNull(sub, "sub");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(givenName, "givenName");
        Utils.checkNotNull(familyName, "familyName");
        Utils.checkNotNull(created, "created");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(accounts, "accounts");
        this.sub = sub;
        this.name = name;
        this.givenName = givenName;
        this.familyName = familyName;
        this.created = created;
        this.email = email;
        this.accounts = accounts;
    }

    @JsonIgnore
    public String sub() {
        return this.sub;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String givenName() {
        return this.givenName;
    }

    @JsonIgnore
    public String familyName() {
        return this.familyName;
    }

    @JsonIgnore
    public String created() {
        return this.created;
    }

    @JsonIgnore
    public String email() {
        return this.email;
    }

    @JsonIgnore
    public List<Account> accounts() {
        return this.accounts;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UserInfo withSub(String sub) {
        Utils.checkNotNull(sub, "sub");
        this.sub = sub;
        return this;
    }

    public UserInfo withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public UserInfo withGivenName(String givenName) {
        Utils.checkNotNull(givenName, "givenName");
        this.givenName = givenName;
        return this;
    }

    public UserInfo withFamilyName(String familyName) {
        Utils.checkNotNull(familyName, "familyName");
        this.familyName = familyName;
        return this;
    }

    public UserInfo withCreated(String created) {
        Utils.checkNotNull(created, "created");
        this.created = created;
        return this;
    }

    public UserInfo withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public UserInfo withAccounts(List<Account> accounts) {
        Utils.checkNotNull(accounts, "accounts");
        this.accounts = accounts;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        return Objects.deepEquals(this.sub, other.sub) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.givenName, other.givenName) && Objects.deepEquals(this.familyName, other.familyName) && Objects.deepEquals(this.created, other.created) && Objects.deepEquals(this.email, other.email) && Objects.deepEquals(this.accounts, other.accounts);
    }

    public int hashCode() {
        return Objects.hash(this.sub, this.name, this.givenName, this.familyName, this.created, this.email, this.accounts);
    }

    public String toString() {
        return Utils.toString(UserInfo.class, "sub", this.sub, "name", this.name, "givenName", this.givenName, "familyName", this.familyName, "created", this.created, "email", this.email, "accounts", this.accounts);
    }

    public static final class Builder {
        private String sub;
        private String name;
        private String givenName;
        private String familyName;
        private String created;
        private String email;
        private List<Account> accounts;

        private Builder() {
        }

        public Builder sub(String sub) {
            Utils.checkNotNull(sub, "sub");
            this.sub = sub;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder givenName(String givenName) {
            Utils.checkNotNull(givenName, "givenName");
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            Utils.checkNotNull(familyName, "familyName");
            this.familyName = familyName;
            return this;
        }

        public Builder created(String created) {
            Utils.checkNotNull(created, "created");
            this.created = created;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder accounts(List<Account> accounts) {
            Utils.checkNotNull(accounts, "accounts");
            this.accounts = accounts;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.sub, this.name, this.givenName, this.familyName, this.created, this.email, this.accounts);
        }
    }
}

