/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenGrantType;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class AuthorizationCodeGrant {
    @SpeakeasyMetadata(value="form:name=grant_type")
    private Optional<? extends GetTokenFromRefreshTokenGrantType> grantType;
    @SpeakeasyMetadata(value="form:name=refresh_token")
    private String refreshToken;
    @SpeakeasyMetadata(value="form:name=client_id")
    private Optional<String> clientId;

    @JsonCreator
    public AuthorizationCodeGrant(Optional<? extends GetTokenFromRefreshTokenGrantType> grantType, String refreshToken, Optional<String> clientId) {
        Utils.checkNotNull(grantType, "grantType");
        Utils.checkNotNull(refreshToken, "refreshToken");
        Utils.checkNotNull(clientId, "clientId");
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.clientId = clientId;
    }

    public AuthorizationCodeGrant(String refreshToken) {
        this(Optional.empty(), refreshToken, Optional.empty());
    }

    @JsonIgnore
    public Optional<GetTokenFromRefreshTokenGrantType> grantType() {
        return this.grantType;
    }

    @JsonIgnore
    public String refreshToken() {
        return this.refreshToken;
    }

    @JsonIgnore
    public Optional<String> clientId() {
        return this.clientId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AuthorizationCodeGrant withGrantType(GetTokenFromRefreshTokenGrantType grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = Optional.ofNullable(grantType);
        return this;
    }

    public AuthorizationCodeGrant withGrantType(Optional<? extends GetTokenFromRefreshTokenGrantType> grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = grantType;
        return this;
    }

    public AuthorizationCodeGrant withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    public AuthorizationCodeGrant withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public AuthorizationCodeGrant withClientId(Optional<String> clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationCodeGrant other = (AuthorizationCodeGrant)o;
        return Objects.deepEquals(this.grantType, other.grantType) && Objects.deepEquals(this.refreshToken, other.refreshToken) && Objects.deepEquals(this.clientId, other.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.grantType, this.refreshToken, this.clientId);
    }

    public String toString() {
        return Utils.toString(AuthorizationCodeGrant.class, "grantType", this.grantType, "refreshToken", this.refreshToken, "clientId", this.clientId);
    }

    public static final class Builder {
        private Optional<? extends GetTokenFromRefreshTokenGrantType> grantType;
        private String refreshToken;
        private Optional<String> clientId = Optional.empty();
        private static final LazySingletonValue<Optional<? extends GetTokenFromRefreshTokenGrantType>> _SINGLETON_VALUE_GrantType = new LazySingletonValue<Optional<? extends GetTokenFromRefreshTokenGrantType>>("grant_type", "\"refresh_token\"", new TypeReference<Optional<? extends GetTokenFromRefreshTokenGrantType>>(){});

        private Builder() {
        }

        public Builder grantType(GetTokenFromRefreshTokenGrantType grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = Optional.ofNullable(grantType);
            return this;
        }

        public Builder grantType(Optional<? extends GetTokenFromRefreshTokenGrantType> grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = grantType;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        public Builder clientId(Optional<String> clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public AuthorizationCodeGrant build() {
            if (this.grantType == null) {
                this.grantType = _SINGLETON_VALUE_GrantType.value();
            }
            return new AuthorizationCodeGrant(this.grantType, this.refreshToken, this.clientId);
        }
    }
}

