/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.TabInfo;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ConnectedFieldsApiGetTabGroupsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<TabInfo>> tabInfos;

    @JsonCreator
    public ConnectedFieldsApiGetTabGroupsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<TabInfo>> tabInfos) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(tabInfos, "tabInfos");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.tabInfos = tabInfos;
    }

    public ConnectedFieldsApiGetTabGroupsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<TabInfo>> tabInfos() {
        return this.tabInfos;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ConnectedFieldsApiGetTabGroupsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsResponse withTabInfos(List<TabInfo> tabInfos) {
        Utils.checkNotNull(tabInfos, "tabInfos");
        this.tabInfos = Optional.ofNullable(tabInfos);
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsResponse withTabInfos(Optional<? extends List<TabInfo>> tabInfos) {
        Utils.checkNotNull(tabInfos, "tabInfos");
        this.tabInfos = tabInfos;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedFieldsApiGetTabGroupsResponse other = (ConnectedFieldsApiGetTabGroupsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.tabInfos, other.tabInfos);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.tabInfos);
    }

    public String toString() {
        return Utils.toString(ConnectedFieldsApiGetTabGroupsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "tabInfos", this.tabInfos);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<TabInfo>> tabInfos = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder tabInfos(List<TabInfo> tabInfos) {
            Utils.checkNotNull(tabInfos, "tabInfos");
            this.tabInfos = Optional.ofNullable(tabInfos);
            return this;
        }

        public Builder tabInfos(Optional<? extends List<TabInfo>> tabInfos) {
            Utils.checkNotNull(tabInfos, "tabInfos");
            this.tabInfos = tabInfos;
            return this;
        }

        public ConnectedFieldsApiGetTabGroupsResponse build() {
            return new ConnectedFieldsApiGetTabGroupsResponse(this.contentType, this.statusCode, this.rawResponse, this.tabInfos);
        }
    }
}

