/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class CreateAgreementSummaryRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private Optional<String> accountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=agreementId")
    private Optional<String> agreementId;

    @JsonCreator
    public CreateAgreementSummaryRequest(Optional<String> accountId, Optional<String> agreementId) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(agreementId, "agreementId");
        this.accountId = accountId;
        this.agreementId = agreementId;
    }

    public CreateAgreementSummaryRequest() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public Optional<String> agreementId() {
        return this.agreementId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateAgreementSummaryRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = Optional.ofNullable(accountId);
        return this;
    }

    public CreateAgreementSummaryRequest withAccountId(Optional<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public CreateAgreementSummaryRequest withAgreementId(String agreementId) {
        Utils.checkNotNull(agreementId, "agreementId");
        this.agreementId = Optional.ofNullable(agreementId);
        return this;
    }

    public CreateAgreementSummaryRequest withAgreementId(Optional<String> agreementId) {
        Utils.checkNotNull(agreementId, "agreementId");
        this.agreementId = agreementId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAgreementSummaryRequest other = (CreateAgreementSummaryRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.agreementId, other.agreementId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.agreementId);
    }

    public String toString() {
        return Utils.toString(CreateAgreementSummaryRequest.class, "accountId", this.accountId, "agreementId", this.agreementId);
    }

    public static final class Builder {
        private Optional<String> accountId;
        private Optional<String> agreementId;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AccountId = new LazySingletonValue<Optional<String>>("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AgreementId = new LazySingletonValue<Optional<String>>("agreementId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = Optional.ofNullable(accountId);
            return this;
        }

        public Builder accountId(Optional<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder agreementId(String agreementId) {
            Utils.checkNotNull(agreementId, "agreementId");
            this.agreementId = Optional.ofNullable(agreementId);
            return this;
        }

        public Builder agreementId(Optional<String> agreementId) {
            Utils.checkNotNull(agreementId, "agreementId");
            this.agreementId = agreementId;
            return this;
        }

        public CreateAgreementSummaryRequest build() {
            if (this.accountId == null) {
                this.accountId = _SINGLETON_VALUE_AccountId.value();
            }
            if (this.agreementId == null) {
                this.agreementId = _SINGLETON_VALUE_AgreementId.value();
            }
            return new CreateAgreementSummaryRequest(this.accountId, this.agreementId);
        }
    }
}

