/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetAgreementResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetAgreementRequestBuilder {
    private Optional<String> accountId = Utils.readDefaultOrConstValue("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});
    private Optional<String> agreementId = Utils.readDefaultOrConstValue("agreementId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetAgreement sdk;
    private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AccountId = new LazySingletonValue<Optional<String>>("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});
    private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AgreementId = new LazySingletonValue<Optional<String>>("agreementId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});

    public GetAgreementRequestBuilder(SDKMethodInterfaces.MethodCallGetAgreement sdk) {
        this.sdk = sdk;
    }

    public GetAgreementRequestBuilder accountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = Optional.of(accountId);
        return this;
    }

    public GetAgreementRequestBuilder accountId(Optional<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetAgreementRequestBuilder agreementId(String agreementId) {
        Utils.checkNotNull(agreementId, "agreementId");
        this.agreementId = Optional.of(agreementId);
        return this;
    }

    public GetAgreementRequestBuilder agreementId(Optional<String> agreementId) {
        Utils.checkNotNull(agreementId, "agreementId");
        this.agreementId = agreementId;
        return this;
    }

    public GetAgreementRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetAgreementRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetAgreementResponse call() throws Exception {
        if (this.accountId == null) {
            this.accountId = _SINGLETON_VALUE_AccountId.value();
        }
        if (this.agreementId == null) {
            this.agreementId = _SINGLETON_VALUE_AgreementId.value();
        }
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getAgreement(this.accountId, this.agreementId, options);
    }
}

