/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.HasSecurity;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class GetTokenFromConfidentialAuthCodeSecurity
implements HasSecurity {
    @JsonProperty(value="clientId")
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=custom,name=clientId")
    private String clientId;
    @JsonProperty(value="secretKey")
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=custom,name=secretKey")
    private String secretKey;

    @JsonCreator
    public GetTokenFromConfidentialAuthCodeSecurity(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="secretKey") String secretKey) {
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(secretKey, "secretKey");
        this.clientId = clientId;
        this.secretKey = secretKey;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String secretKey() {
        return this.secretKey;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetTokenFromConfidentialAuthCodeSecurity withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public GetTokenFromConfidentialAuthCodeSecurity withSecretKey(String secretKey) {
        Utils.checkNotNull(secretKey, "secretKey");
        this.secretKey = secretKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTokenFromConfidentialAuthCodeSecurity other = (GetTokenFromConfidentialAuthCodeSecurity)o;
        return Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.secretKey, other.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secretKey);
    }

    public String toString() {
        return Utils.toString(GetTokenFromConfidentialAuthCodeSecurity.class, "clientId", this.clientId, "secretKey", this.secretKey);
    }

    public static final class Builder {
        private String clientId;
        private String secretKey;

        private Builder() {
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder secretKey(String secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            this.secretKey = secretKey;
            return this;
        }

        public GetTokenFromConfidentialAuthCodeSecurity build() {
            return new GetTokenFromConfidentialAuthCodeSecurity(this.clientId, this.secretKey);
        }
    }
}

