/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.AuthorizationCodeGrantResponse;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetTokenFromPublicAuthCodeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AuthorizationCodeGrantResponse> authorizationCodeGrantResponse;

    @JsonCreator
    public GetTokenFromPublicAuthCodeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AuthorizationCodeGrantResponse> authorizationCodeGrantResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(authorizationCodeGrantResponse, "authorizationCodeGrantResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.authorizationCodeGrantResponse = authorizationCodeGrantResponse;
    }

    public GetTokenFromPublicAuthCodeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AuthorizationCodeGrantResponse> authorizationCodeGrantResponse() {
        return this.authorizationCodeGrantResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetTokenFromPublicAuthCodeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetTokenFromPublicAuthCodeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetTokenFromPublicAuthCodeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetTokenFromPublicAuthCodeResponse withAuthorizationCodeGrantResponse(AuthorizationCodeGrantResponse authorizationCodeGrantResponse) {
        Utils.checkNotNull(authorizationCodeGrantResponse, "authorizationCodeGrantResponse");
        this.authorizationCodeGrantResponse = Optional.ofNullable(authorizationCodeGrantResponse);
        return this;
    }

    public GetTokenFromPublicAuthCodeResponse withAuthorizationCodeGrantResponse(Optional<? extends AuthorizationCodeGrantResponse> authorizationCodeGrantResponse) {
        Utils.checkNotNull(authorizationCodeGrantResponse, "authorizationCodeGrantResponse");
        this.authorizationCodeGrantResponse = authorizationCodeGrantResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTokenFromPublicAuthCodeResponse other = (GetTokenFromPublicAuthCodeResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.authorizationCodeGrantResponse, other.authorizationCodeGrantResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.authorizationCodeGrantResponse);
    }

    public String toString() {
        return Utils.toString(GetTokenFromPublicAuthCodeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "authorizationCodeGrantResponse", this.authorizationCodeGrantResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AuthorizationCodeGrantResponse> authorizationCodeGrantResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder authorizationCodeGrantResponse(AuthorizationCodeGrantResponse authorizationCodeGrantResponse) {
            Utils.checkNotNull(authorizationCodeGrantResponse, "authorizationCodeGrantResponse");
            this.authorizationCodeGrantResponse = Optional.ofNullable(authorizationCodeGrantResponse);
            return this;
        }

        public Builder authorizationCodeGrantResponse(Optional<? extends AuthorizationCodeGrantResponse> authorizationCodeGrantResponse) {
            Utils.checkNotNull(authorizationCodeGrantResponse, "authorizationCodeGrantResponse");
            this.authorizationCodeGrantResponse = authorizationCodeGrantResponse;
            return this;
        }

        public GetTokenFromPublicAuthCodeResponse build() {
            return new GetTokenFromPublicAuthCodeResponse(this.contentType, this.statusCode, this.rawResponse, this.authorizationCodeGrantResponse);
        }
    }
}

