/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.AuthorizationCodeGrant;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenSecurity;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class GetTokenFromRefreshTokenRequestBuilder {
    private AuthorizationCodeGrant request;
    private GetTokenFromRefreshTokenSecurity security;
    private Optional<String> serverURL = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetTokenFromRefreshToken sdk;

    public GetTokenFromRefreshTokenRequestBuilder(SDKMethodInterfaces.MethodCallGetTokenFromRefreshToken sdk) {
        this.sdk = sdk;
    }

    public GetTokenFromRefreshTokenRequestBuilder request(AuthorizationCodeGrant request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public GetTokenFromRefreshTokenRequestBuilder security(GetTokenFromRefreshTokenSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public GetTokenFromRefreshTokenRequestBuilder serverURL(String serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = Optional.of(serverURL);
        return this;
    }

    public GetTokenFromRefreshTokenRequestBuilder serverURL(Optional<String> serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = serverURL;
        return this;
    }

    public GetTokenFromRefreshTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetTokenFromRefreshTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetTokenFromRefreshTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getTokenFromRefreshToken(this.request, this.security, this.serverURL, options);
    }
}

