/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetWorkflowInstanceResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class GetWorkflowInstanceRequestBuilder {
    private String accountId;
    private String workflowId;
    private String instanceId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetWorkflowInstance sdk;

    public GetWorkflowInstanceRequestBuilder(SDKMethodInterfaces.MethodCallGetWorkflowInstance sdk) {
        this.sdk = sdk;
    }

    public GetWorkflowInstanceRequestBuilder accountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetWorkflowInstanceRequestBuilder workflowId(String workflowId) {
        Utils.checkNotNull(workflowId, "workflowId");
        this.workflowId = workflowId;
        return this;
    }

    public GetWorkflowInstanceRequestBuilder instanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public GetWorkflowInstanceRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetWorkflowInstanceRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetWorkflowInstanceResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getWorkflowInstance(this.accountId, this.workflowId, this.instanceId, options);
    }
}

