/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.WorkflowInstance;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetWorkflowInstanceResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WorkflowInstance> workflowInstance;

    @JsonCreator
    public GetWorkflowInstanceResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WorkflowInstance> workflowInstance) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workflowInstance, "workflowInstance");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workflowInstance = workflowInstance;
    }

    public GetWorkflowInstanceResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkflowInstance> workflowInstance() {
        return this.workflowInstance;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowInstanceResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetWorkflowInstanceResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetWorkflowInstanceResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetWorkflowInstanceResponse withWorkflowInstance(WorkflowInstance workflowInstance) {
        Utils.checkNotNull(workflowInstance, "workflowInstance");
        this.workflowInstance = Optional.ofNullable(workflowInstance);
        return this;
    }

    public GetWorkflowInstanceResponse withWorkflowInstance(Optional<? extends WorkflowInstance> workflowInstance) {
        Utils.checkNotNull(workflowInstance, "workflowInstance");
        this.workflowInstance = workflowInstance;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowInstanceResponse other = (GetWorkflowInstanceResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.workflowInstance, other.workflowInstance);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.workflowInstance);
    }

    public String toString() {
        return Utils.toString(GetWorkflowInstanceResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workflowInstance", this.workflowInstance);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WorkflowInstance> workflowInstance = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workflowInstance(WorkflowInstance workflowInstance) {
            Utils.checkNotNull(workflowInstance, "workflowInstance");
            this.workflowInstance = Optional.ofNullable(workflowInstance);
            return this;
        }

        public Builder workflowInstance(Optional<? extends WorkflowInstance> workflowInstance) {
            Utils.checkNotNull(workflowInstance, "workflowInstance");
            this.workflowInstance = workflowInstance;
            return this;
        }

        public GetWorkflowInstanceResponse build() {
            return new GetWorkflowInstanceResponse(this.contentType, this.statusCode, this.rawResponse, this.workflowInstance);
        }
    }
}

